/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.time;

import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.random.Randoms;
import cn.orionsec.kit.lang.utils.time.DateStream;
import cn.orionsec.kit.lang.utils.time.Dates;
import java.util.Calendar;
import java.util.Date;

public class Birthdays {
    private Birthdays() {
    }

    public static int getBirthdayYear(int age) {
        return Dates.stream().getYear() - age;
    }

    public static String generatorBirthday(int age) {
        int year = Birthdays.getBirthdayYear(age);
        int month = Randoms.randomInt(12) + 1;
        int day = Randoms.randomInt(Dates.getMonthLastDay(year, month)) + 1;
        DateStream curr = Dates.stream();
        DateStream birthday = Dates.stream(Dates.build(year, month, day));
        int currMonth = curr.getMonth();
        if (month > currMonth) {
            birthday.subYear(1);
        } else if (month == currMonth && day > curr.getDay()) {
            birthday.subMonth(1);
        }
        return birthday.format("yyyyMMdd");
    }

    public static boolean todayIsBirthday(Date birthday) {
        DateStream today = Dates.stream();
        DateStream bir = Dates.stream(birthday);
        return today.getMonth() == bir.getMonth() && today.getDay() == bir.getDay();
    }

    public static boolean isBirthday(int year, int month, int day) {
        if (year < 1900) {
            return false;
        }
        if (month < 1 || month > 12) {
            return false;
        }
        if (day < 1 || day > 31) {
            return false;
        }
        if (day == 31 && (month == 4 || month == 6 || month == 9 || month == 11)) {
            return false;
        }
        if (month == 2) {
            return day < 29 || day == 29 && Dates.isLeapYear(year);
        }
        return true;
    }

    public static boolean isBirthdayNotFuture(int year, int month, int day) {
        return Birthdays.isBirthday(year, month, day) && !Dates.inFuture(Dates.build(year, month, day));
    }

    public static int getAge(Date birthday) {
        return Birthdays.getAge(birthday.getTime(), System.currentTimeMillis());
    }

    public static int getAge(long birthday) {
        return Birthdays.getAge(birthday, System.currentTimeMillis());
    }

    public static int getAge(Date birthday, Date range) {
        if (range == null) {
            range = new Date();
        }
        return Birthdays.getAge(birthday.getTime(), range.getTime());
    }

    public static int getAge(long birthday, long range) {
        if (birthday > range) {
            throw Exceptions.argument("birthday is after range");
        }
        Calendar c = Dates.calendar(range);
        int year = c.get(1);
        int month = c.get(2);
        int dayOfMonth = c.get(5);
        boolean isLastDayOfMonth = dayOfMonth == c.getActualMaximum(5);
        c.setTimeInMillis(birthday);
        int age = year - c.get(1);
        int monthBirth = c.get(2);
        if (month == monthBirth) {
            boolean isLastDayOfMonthBirth;
            int dayOfMonthBirth = c.get(5);
            boolean bl = isLastDayOfMonthBirth = dayOfMonthBirth == c.getActualMaximum(5);
            if (!(isLastDayOfMonth && isLastDayOfMonthBirth || dayOfMonth >= dayOfMonthBirth)) {
                --age;
            }
        } else if (month < monthBirth) {
            --age;
        }
        return age;
    }
}

