/*
 * Decompiled with CFR 0.152.
 */
package cn.playalot.play2.mailgun;

import akka.stream.scaladsl.FileIO$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.util.ByteString;
import cn.playalot.play2.mailgun.EssentialEmailMessage;
import cn.playalot.play2.mailgun.MailgunAttachment;
import cn.playalot.play2.mailgun.MailgunAuthenticationException;
import cn.playalot.play2.mailgun.MailgunOption;
import cn.playalot.play2.mailgun.MailgunResponse;
import cn.playalot.play2.mailgun.MailgunResponseJson;
import cn.playalot.play2.mailgun.MailgunSendingException;
import java.io.File;
import java.io.Serializable;
import javax.inject.Inject;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.http.Status$;
import play.api.libs.json.JsLookup$;
import play.api.libs.json.JsValue$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.ws.WSAuthScheme;
import play.api.libs.ws.WSClient;
import play.api.libs.ws.WSRequest;
import play.api.libs.ws.WSResponse;
import play.api.mvc.MultipartFormData;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005]w!B\u0001\u0003\u0011\u0003Y\u0011aE'bS2<WO\\#nC&d7+\u001a:wS\u000e,'BA\u0002\u0005\u0003\u001di\u0017-\u001b7hk:T!!\u0002\u0004\u0002\u000bAd\u0017-\u001f\u001a\u000b\u0005\u001dA\u0011\u0001\u00039mCf\fGn\u001c;\u000b\u0003%\t!a\u00198\u0004\u0001A\u0011A\"D\u0007\u0002\u0005\u0019)aB\u0001E\u0001\u001f\t\u0019R*Y5mOVtW)\\1jYN+'O^5dKN\u0011Q\u0002\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000b]iA\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005YQ\u0001\u0002\u000e\u000e\u0001m\u0011!#\u0011;uC\u000eDW.\u001a8u!\u0006\u0014H\u000fV=qKB!AdI\u0013,\u001b\u0005i\"B\u0001\u0010 \u0003!\u00198-\u00197bINd'B\u0001\u0011\"\u0003\u0019\u0019HO]3b[*\t!%\u0001\u0003bW.\f\u0017B\u0001\u0013\u001e\u0005\u0019\u0019v.\u001e:dKB\u0011a%K\u0007\u0002O)\u0011\u0001&I\u0001\u0005kRLG.\u0003\u0002+O\tQ!)\u001f;f'R\u0014\u0018N\\4\u0011\u0005Ea\u0013BA\u0017\u0013\u0005\r\te._\u0003\u0005_5\u0001\u0001G\u0001\u0005Q_N$H)\u0019;ba\t\tD\t\u0005\u0003\u001dGI\u0012\u0005cA\u001a>\u0001:\u0011AgO\u0007\u0002k)\u0011agN\u0001\u0004[Z\u001c'B\u0001\u001d:\u0003\r\t\u0007/\u001b\u0006\u0002u\u0005!\u0001\u000f\\1z\u0013\taT'A\tNk2$\u0018\u000e]1si\u001a{'/\u001c#bi\u0006L!AP \u0003\tA\u000b'\u000f\u001e\u0006\u0003yU\u0002\"!Q\r\u000e\u00035\u0001\"a\u0011#\r\u0001\u0011IQILA\u0001\u0002\u0003\u0015\tA\u0012\u0002\u0004?\u0012\n\u0014CA$,!\t\t\u0002*\u0003\u0002J%\t9aj\u001c;iS:<g\u0001\u0002\b\u0003\u0001-\u001b2A\u0013\tM!\taQ*\u0003\u0002O\u0005\t\u0019R*Y5mOVt'+Z:q_:\u001cXMS:p]\"A\u0001K\u0013B\u0001B\u0003%\u0011+\u0001\u0005xg\u000ec\u0017.\u001a8u!\t\u0011v+D\u0001T\u0015\t!V+\u0001\u0002xg*\u0011akN\u0001\u0005Y&\u00147/\u0003\u0002Y'\nAqkU\"mS\u0016tG\u000f\u0003\u0005[\u0015\n\u0005\t\u0015!\u0003\\\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u0011A,X\u0007\u0002o%\u0011al\u000e\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000b]QE\u0011\u00011\u0015\u0007\u0005\u00147\r\u0005\u0002\r\u0015\")\u0001k\u0018a\u0001#\")!l\u0018a\u00017\"\u0012q,\u001a\t\u0003M.l\u0011a\u001a\u0006\u0003Q&\fa!\u001b8kK\u000e$(\"\u00016\u0002\u000b)\fg/\u0019=\n\u00051<'AB%oU\u0016\u001cG\u000f\u0003\u0005o\u0015\"\u0015\r\u0011\"\u0001p\u00035i\u0017-\u001b7hk:\f\u0005/[&fsV\t\u0001\u000f\u0005\u0002rq:\u0011!O\u001e\t\u0003gJi\u0011\u0001\u001e\u0006\u0003k*\ta\u0001\u0010:p_Rt\u0014BA<\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011P\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005]\u0014\u0002\u0002\u0003?K\u0011\u000b\u0007I\u0011A?\u0002\u001b\u0011,g-Y;miN+g\u000eZ3s+\u0005q\bcA\t\u0000a&\u0019\u0011\u0011\u0001\n\u0003\r=\u0003H/[8o\u0011%\t)A\u0013EC\u0002\u0013\u0005q.\u0001\u0006nC&dw-\u001e8Ve2D\u0011\u0002\u0016&\t\u0006\u0004%\t!!\u0003\u0016\u0005\u0005-\u0001c\u0001*\u0002\u000e%\u0019\u0011qB*\u0003\u0013]\u001b&+Z9vKN$\bbBA\n\u0015\u0012\u0005\u0011QC\u0001\u0005g\u0016tG\r\u0006\u0004\u0002\u0018\u0005%\u00121\u0007\t\u0007\u00033\ty\"a\t\u000e\u0005\u0005m!bAA\u000f%\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005\u0005\u00121\u0004\u0002\u0007\rV$XO]3\u0011\u00071\t)#C\u0002\u0002(\t\u0011q\"T1jY\u001e,hNU3ta>t7/\u001a\u0005\t\u0003W\t\t\u00021\u0001\u0002.\u00059Q.Z:tC\u001e,\u0007c\u0001\u0007\u00020%\u0019\u0011\u0011\u0007\u0002\u0003+\u0015\u001b8/\u001a8uS\u0006dW)\\1jY6+7o]1hK\"Q\u0011QGA\t!\u0003\u0005\r!a\u000e\u0002\u000f=\u0004H/[8ogB)\u0011/!\u000f\u0002>%\u0019\u00111\b>\u0003\u0007M+G\u000fE\u0002\r\u0003\u007fI1!!\u0011\u0003\u00055i\u0015-\u001b7hk:|\u0005\u000f^5p]\"9\u0011Q\t&\u0005\n\u0005\u001d\u0013!\u00062vS2$W*\u001e7uSB\f'\u000f\u001e*fcV,7\u000f\u001e\u000b\t\u0003\u0013\ni%!\u0015\u0002TA\u0019\u00111\n\u0018\u000f\u00051\u0001\u0001bBA(\u0003\u0007\u0002\r\u0001]\u0001\u0007g\u0016tG-\u001a:\t\u0011\u0005-\u00121\ta\u0001\u0003[A\u0001\"!\u000e\u0002D\u0001\u0007\u0011q\u0007\u0005\b\u0003/RE\u0011BA-\u0003=\u0011W/\u001b7e\u0003R$\u0018m\u00195nK:$H\u0003BA.\u0003\u0007\u0003b!!\u0018\u0002l\u0005=dbAA0w9!\u0011\u0011MA5\u001d\u0011\t\u0019'a\u001a\u000f\u0007M\f)'C\u0001;\u0013\tA\u0014(\u0003\u00027o%\u0019\u0011QN \u0003\u0011\u0019KG.\u001a)beR\u00042!!\u001d\u001a\u001d\r\t\u0019\b\u0001\b\u0005\u0003k\n\tI\u0004\u0003\u0002x\u0005}d\u0002BA=\u0003{r1a]A>\u0013\u0005I\u0011BA\u0004\t\u0013\t)a!\u0003\u0002\u0004\t!A\u0011QQA+\u0001\u0004\t9)\u0001\u0006biR\f7\r[7f]R\u00042\u0001DAE\u0013\r\tYI\u0001\u0002\u0012\u001b\u0006LGnZ;o\u0003R$\u0018m\u00195nK:$\bbBAH\u0015\u0012%\u0011\u0011S\u0001\u000bC\u0012$w\n\u001d;j_:\u001cHCBAJ\u0003O\u000bY\u000b\u0005\u0004\u0002\u0016\u0006}\u0015Q\u0015\b\u0005\u0003/\u000bYJD\u0002t\u00033K\u0011aE\u0005\u0004\u0003;\u0013\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003C\u000b\u0019K\u0001\u0003MSN$(bAAO%A)\u0011QL\u001f\u0002p!A\u0011\u0011VAG\u0001\u0004\t\u0019*\u0001\u0006cCNL7\rU1siND\u0001\"!\u000e\u0002\u000e\u0002\u0007\u0011q\u0007\u0005\b\u0003_SE\u0011BAY\u0003UA\u0017M\u001c3mK6\u000b\u0017\u000e\\4v]J+7\u000f]8og\u0016$B!a\u0006\u00024\"A\u0011QWAW\u0001\u0004\t9,\u0001\u0005sKN\u0004xN\\:f!\r\u0011\u0016\u0011X\u0005\u0004\u0003w\u001b&AC,T%\u0016\u001c\bo\u001c8tK\"I\u0011q\u0018&\u0012\u0002\u0013\u0005\u0011\u0011Y\u0001\u000fg\u0016tG\r\n3fM\u0006,H\u000e\u001e\u00133+\t\t\u0019M\u000b\u0003\u00028\u0005\u00157FAAd!\u0011\tI-a5\u000e\u0005\u0005-'\u0002BAg\u0003\u001f\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005E'#\u0001\u0006b]:|G/\u0019;j_:LA!!6\u0002L\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class MailgunEmailService
implements MailgunResponseJson {
    private String mailgunApiKey;
    private Option<String> defaultSender;
    private String mailgunUrl;
    private WSRequest ws;
    private final WSClient wsClient;
    private final Configuration configuration;
    private final Reads<MailgunResponse> responseReads;
    private volatile byte bitmap$0;

    @Override
    public Reads<MailgunResponse> responseReads() {
        return this.responseReads;
    }

    @Override
    public void cn$playalot$play2$mailgun$MailgunResponseJson$_setter_$responseReads_$eq(Reads<MailgunResponse> x$1) {
        this.responseReads = x$1;
    }

    private String mailgunApiKey$lzycompute() {
        MailgunEmailService mailgunEmailService = this;
        synchronized (mailgunEmailService) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.mailgunApiKey = (String)this.configuration.get("mailgun.api.key", ConfigLoader$.MODULE$.stringLoader());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.mailgunApiKey;
    }

    public String mailgunApiKey() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.mailgunApiKey$lzycompute() : this.mailgunApiKey;
    }

    private Option<String> defaultSender$lzycompute() {
        MailgunEmailService mailgunEmailService = this;
        synchronized (mailgunEmailService) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.defaultSender = this.configuration.getOptional("mailgun.default.sender", ConfigLoader$.MODULE$.stringLoader());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.defaultSender;
    }

    public Option<String> defaultSender() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.defaultSender$lzycompute() : this.defaultSender;
    }

    private String mailgunUrl$lzycompute() {
        MailgunEmailService mailgunEmailService = this;
        synchronized (mailgunEmailService) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.mailgunUrl = (String)this.configuration.get("mailgun.api.url", ConfigLoader$.MODULE$.stringLoader());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.mailgunUrl;
    }

    public String mailgunUrl() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.mailgunUrl$lzycompute() : this.mailgunUrl;
    }

    private WSRequest ws$lzycompute() {
        MailgunEmailService mailgunEmailService = this;
        synchronized (mailgunEmailService) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.ws = this.wsClient.url(this.mailgunUrl());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        this.wsClient = null;
        return this.ws;
    }

    public WSRequest ws() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.ws$lzycompute() : this.ws;
    }

    public Future<MailgunResponse> send(EssentialEmailMessage message, Set<MailgunOption> options) {
        Future future;
        if (this.defaultSender().isEmpty() && message.from().isEmpty()) {
            future = Future$.MODULE$.failed((Throwable)new IllegalStateException("From: field is None and no default sender configured"));
        } else {
            String sender = (String)message.from().getOrElse((Function0 & Serializable & scala.Serializable)() -> (String)this.defaultSender().get());
            future = this.ws().withAuth("api", this.mailgunApiKey(), (WSAuthScheme)WSAuthScheme.BASIC$.MODULE$).post(this.buildMultipartRequest(sender, message, options)).flatMap((Function1 & Serializable & scala.Serializable)response -> this.handleMailgunResponse((WSResponse)response), ExecutionContext.Implicits$.MODULE$.global());
        }
        return future;
    }

    public Set<MailgunOption> send$default$2() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
    }

    private Source<MultipartFormData.Part<Source<ByteString, Object>>, ?> buildMultipartRequest(String sender, EssentialEmailMessage message, Set<MailgunOption> options) {
        List requiredParts = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MultipartFormData.DataPart[]{new MultipartFormData.DataPart("from", sender), new MultipartFormData.DataPart("to", message.to()), new MultipartFormData.DataPart("subject", message.subject()), new MultipartFormData.DataPart("text", message.text()), new MultipartFormData.DataPart("html", message.html().toString())}));
        List optionalParts = (List)((List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{message.cc().map((Function1 & Serializable & scala.Serializable)x$1 -> new MultipartFormData.DataPart("cc", x$1)), message.bcc().map((Function1 & Serializable & scala.Serializable)x$2 -> new MultipartFormData.DataPart("bcc", x$2))})).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).$plus$plus((GenTraversableOnce)message.computedHeaders().map((Function1 & Serializable & scala.Serializable)hdr -> new MultipartFormData.DataPart(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"h:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hdr._1()})), (String)hdr._2()), Seq$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        Seq attachments = (Seq)message.attachments().map((Function1 & Serializable & scala.Serializable)attachment -> this.buildAttachment((MailgunAttachment)attachment), Seq$.MODULE$.canBuildFrom());
        return Source$.MODULE$.apply(this.addOptions((List<MultipartFormData.Part<Source<ByteString, Object>>>)((List)((List)requiredParts.$plus$plus((GenTraversableOnce)optionalParts, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)attachments, List$.MODULE$.canBuildFrom())), options));
    }

    private MultipartFormData.FilePart<Source<ByteString, Object>> buildAttachment(MailgunAttachment attachment) {
        File theFile = attachment.file();
        return new MultipartFormData.FilePart("attachment", attachment.fileName(), attachment.contentType(), (Object)FileIO$.MODULE$.fromFile(theFile, FileIO$.MODULE$.fromFile$default$2()));
    }

    private List<MultipartFormData.Part<Source<ByteString, Object>>> addOptions(List<MultipartFormData.Part<Source<ByteString, Object>>> basicParts, Set<MailgunOption> options) {
        return (List)basicParts.$plus$plus((GenTraversableOnce)options.map((Function1 & Serializable & scala.Serializable)o -> {
            Logger$.MODULE$.debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding option ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{o, o.renderAsApiParameter()})), MarkerContext$.MODULE$.NoMarker());
            return o.renderAsApiParameter();
        }, Set$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
    }

    private Future<MailgunResponse> handleMailgunResponse(WSResponse response) {
        Future future;
        if (response.status() == Status$.MODULE$.OK()) {
            future = Future$.MODULE$.successful(response.json().as(this.responseReads()));
        } else {
            int n = response.status();
            MailgunSendingException mailgunSendingException = Status$.MODULE$.UNAUTHORIZED() == n ? new MailgunAuthenticationException((String)JsLookup$.MODULE$.$bslash$extension1(JsValue$.MODULE$.jsValueToJsLookup(response.json()), "message").as((Reads)Reads$.MODULE$.StringReads())) : new MailgunSendingException((String)JsLookup$.MODULE$.$bslash$extension1(JsValue$.MODULE$.jsValueToJsLookup(response.json()), "message").as((Reads)Reads$.MODULE$.StringReads()));
            future = Future$.MODULE$.failed((Throwable)mailgunSendingException);
        }
        return future;
    }

    @Inject
    public MailgunEmailService(WSClient wsClient, Configuration configuration) {
        this.wsClient = wsClient;
        this.configuration = configuration;
        MailgunResponseJson.$init$(this);
    }
}

