/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.collect;

import code.ponfee.commons.collect.ByteArrayComparator;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public final class ByteArrayWrapper
implements Serializable,
Comparable<ByteArrayWrapper> {
    private static final long serialVersionUID = -8749483734287105153L;
    private final byte[] array;
    private final int hashCode;

    public ByteArrayWrapper(Byte ... array) {
        this(ArrayUtils.toPrimitive((Byte[])array));
    }

    public ByteArrayWrapper(byte ... array) {
        this.array = array;
        this.hashCode = Arrays.hashCode(array);
    }

    public static ByteArrayWrapper of(byte ... array) {
        return new ByteArrayWrapper(array);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ByteArrayWrapper) {
            return Arrays.equals(this.array, ((ByteArrayWrapper)other).array);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int compareTo(ByteArrayWrapper o) {
        return ByteArrayComparator.compareTo(this.array, o.array);
    }

    public byte[] getArray() {
        return this.array;
    }

    public String toString() {
        return "ByteArrayWrapper[" + (this.array == null ? "null" : Integer.valueOf(this.array.length)) + "]";
    }
}

