/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.collect;

import code.ponfee.commons.math.Numbers;
import code.ponfee.commons.util.ObjectUtils;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.util.Assert;

public final class Collects {
    public static <T> T[] toArray(T ... args) {
        return args;
    }

    public static List<Object> toList(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj.getClass().isArray()) {
            int length = Array.getLength(obj);
            ArrayList<Object> result = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                result.add(Array.get(obj, i));
            }
            return result;
        }
        if (obj instanceof Collection) {
            return new ArrayList<Object>((Collection)obj);
        }
        return Collections.singletonList(obj);
    }

    public static <E> LinkedList<E> newLinkedList(E element) {
        LinkedList<E> list = new LinkedList<E>();
        list.add(element);
        return list;
    }

    public static <T> T getFirst(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (T)(list instanceof Deque ? ((Deque)((Object)list)).getFirst() : list.get(0));
    }

    public static <T> T getLast(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (T)(list instanceof Deque ? ((Deque)((Object)list)).getLast() : list.get(list.size() - 1));
    }

    public static <T> T get(T[] array, int index) {
        if (array == null) {
            return null;
        }
        return index < array.length ? (T)array[index] : null;
    }

    public static <T> T get(List<T> list, int index) {
        if (list == null) {
            return null;
        }
        return index < list.size() ? (T)list.get(index) : null;
    }

    public static <T> List<T> intersect(Collection<T> coll1, Collection<T> coll2) {
        return coll1.stream().filter(coll2::contains).collect(Collectors.toList());
    }

    public static <T> T[] intersect(T[] array1, T[] array2) {
        List<Object> list = Stream.of(array1).filter(t -> ArrayUtils.contains((Object[])array2, (Object)t)).collect(Collectors.toList());
        Class<?> type = array1.getClass().getComponentType();
        return list.toArray((Object[])Array.newInstance(type, list.size()));
    }

    public static <T> List<T> union(Collection<T> coll1, Collection<T> coll2) {
        int min;
        int max = coll1.size();
        if (max < (min = coll2.size())) {
            int tmp = max;
            max = min;
            min = tmp;
        }
        ArrayList<T> res = new ArrayList<T>(max + (min >> 1));
        res.addAll(coll1);
        coll2.stream().filter(ObjectUtils.not(coll1::contains)).forEach(res::add);
        return res;
    }

    public static <T> List<T> different(List<T> list1, List<T> list2) {
        ArrayList res = new ArrayList();
        list1.stream().filter(ObjectUtils.not(list2::contains)).forEach(res::add);
        list2.stream().filter(ObjectUtils.not(list1::contains)).forEach(res::add);
        return res;
    }

    public static <T> Set<T> different(Set<T> set1, Set<T> set2) {
        HashSet res = new HashSet();
        set1.stream().filter(ObjectUtils.not(set2::contains)).forEach(res::add);
        set2.stream().filter(ObjectUtils.not(set1::contains)).forEach(res::add);
        return res;
    }

    public static <K, V> Map<K, V> different(Map<K, V> map1, Map<K, V> map2) {
        HashMap res = new HashMap(Math.max(map1.size(), map2.size()));
        map1.entrySet().stream().filter(e -> !map2.containsKey(e.getKey())).forEach(e -> res.put(e.getKey(), e.getValue()));
        map2.entrySet().stream().filter(e -> !map1.containsKey(e.getKey())).forEach(e -> res.put(e.getKey(), e.getValue()));
        return res;
    }

    public static <T> List<T> duplicate(Collection<T> list) {
        return Collects.duplicate(list, Function.identity());
    }

    public static <T, R> List<R> duplicate(Collection<T> list, Function<T, R> mapper) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return list.stream().map(mapper).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static <T> T[] concat(IntFunction<T[]> generator, T[] ... arrays) {
        if (ArrayUtils.isEmpty(arrays)) {
            return null;
        }
        return Arrays.stream(arrays).filter(Objects::nonNull).flatMap(Arrays::stream).toArray(generator);
    }

    public static <T> void set(List<T> list, int index, T obj) {
        for (int i = list.size(); i <= index; ++i) {
            list.add(null);
        }
        list.set(index, obj);
    }

    public static <T> void expand(List<T> list, int size, Supplier<T> supplier) {
        for (int i = list.size(); i <= size; ++i) {
            list.add(supplier.get());
        }
    }

    public static <A, B, T> List<List<T>> cartesian(List<A> x, List<B> y, BiFunction<A, B, T> fun) {
        ArrayList<List<T>> product = new ArrayList<List<T>>(x.size());
        for (A a : x) {
            ArrayList<T> row = new ArrayList<T>(y.size());
            for (B b : y) {
                row.add(fun.apply(a, b));
            }
            product.add(row);
        }
        return product;
    }

    public static List<int[]> partition(int[] array, int size) {
        Assert.isTrue((size > 0 ? 1 : 0) != 0, (String)"Size must be greater than 0.");
        if (array == null || array.length == 0) {
            return null;
        }
        if ((size = Math.min(size, array.length)) == 1) {
            return Collections.singletonList(array);
        }
        ArrayList<int[]> result = new ArrayList<int[]>(size);
        int pos = 0;
        for (int number : Numbers.slice(array.length, size)) {
            if (number == 0) break;
            result.add(Arrays.copyOfRange(array, pos, pos += number));
        }
        return result;
    }

    public static List<Object[]> rotate(List<Object[]> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        int length = list.get(0).length;
        int size = list.size();
        ArrayList<Object[]> result = new ArrayList<Object[]>(length);
        for (int i = 0; i < length; ++i) {
            Object[] array = new Object[size];
            for (int j = 0; j < size; ++j) {
                array[j] = list.get(j)[i];
            }
            result.add(array);
        }
        return result;
    }

    public static int[] sortAndGetIndexSwapMapping(int[] array) {
        int[] indexSwapMapping = IntStream.range(0, array.length).toArray();
        int n = array.length - 1;
        for (int i = 0; i < n; ++i) {
            int minimumIndex = i;
            for (int j = i + 1; j <= n; ++j) {
                if (array[minimumIndex] <= array[j]) continue;
                minimumIndex = j;
            }
            if (minimumIndex == i) continue;
            ArrayUtils.swap((int[])array, (int)i, (int)minimumIndex);
            ArrayUtils.swap((int[])indexSwapMapping, (int)i, (int)minimumIndex);
        }
        return indexSwapMapping;
    }

    public static <T> T[] requireNonEmpty(T[] array) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            throw new IllegalStateException("The array cannot be empty.");
        }
        return array;
    }

    public static <T> List<T> requireNonEmpty(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new IllegalStateException("The list cannot be empty.");
        }
        return list;
    }

    public static <S, T> List<T> convert(List<S> source, Function<S, T> mapper) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)source.size());
        source.stream().map(mapper).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    @SafeVarargs
    public static <T> List<T> concat(List<T> list, T ... array) {
        if (list == null) {
            return array == null ? Collections.emptyList() : Arrays.asList(array);
        }
        if (array == null || array.length == 0) {
            return list;
        }
        ArrayList<T> result = new ArrayList<T>(list.size() + array.length);
        result.addAll(list);
        Collections.addAll(result, array);
        return result;
    }

    public static <T> T[] newArray(Class<? extends T[]> newType, int length) {
        return newType == Object[].class ? new Object[length] : (Object[])Array.newInstance(newType.getComponentType(), length);
    }
}

