/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.collect;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;

public class FilterableIterator<T>
implements Iterable<T>,
Iterator<T> {
    private final Predicate<T> predicate;
    private final Iterator<T> iterator;
    private T current;

    private FilterableIterator(Iterator<T> iterator) {
        this(Objects::nonNull, iterator);
    }

    private FilterableIterator(Predicate<T> predicate, Iterator<T> iterator) {
        this.predicate = predicate;
        this.iterator = iterator;
    }

    public static <T> FilterableIterator<T> of(Iterator<T> iterator) {
        return new FilterableIterator<T>(iterator);
    }

    public static <T> FilterableIterator<T> of(Predicate<T> predicate, Iterator<T> iterator) {
        return new FilterableIterator<T>(predicate, iterator);
    }

    public static <T> FilterableIterator<T> of(Iterable<T> iterable) {
        return new FilterableIterator<T>(iterable.iterator());
    }

    public static <T> FilterableIterator<T> of(Predicate<T> predicate, Iterable<T> iterable) {
        return new FilterableIterator<T>(predicate, iterable.iterator());
    }

    @SafeVarargs
    public static <T> FilterableIterator<T> of(T ... array) {
        return new FilterableIterator(new ArrayIterator((Object[])array));
    }

    @SafeVarargs
    public static <T> FilterableIterator<T> of(Predicate<T> predicate, T ... array) {
        return new FilterableIterator<T>(predicate, new ArrayIterator((Object[])array));
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        while (this.iterator.hasNext()) {
            this.current = this.iterator.next();
            if (!this.predicate.test(this.current)) continue;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        return this.current;
    }

    private static class ArrayIterator<T>
    implements Iterator<T> {
        private final T[] array;
        private int cursor = 0;

        @SafeVarargs
        private ArrayIterator(T ... array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.array != null && this.cursor != this.array.length;
        }

        @Override
        public T next() {
            return this.array[this.cursor++];
        }
    }
}

