/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;

public class NamedThreadFactory
implements ThreadFactory {
    private static final AtomicInteger POOL_SEQ = new AtomicInteger(1);
    private final AtomicInteger threadNo = new AtomicInteger(1);
    private final String prefix;
    private final boolean daemon;
    private final ThreadGroup group;

    public NamedThreadFactory() {
        this(null, Thread.currentThread().isDaemon());
    }

    public NamedThreadFactory(String prefix) {
        this(prefix, Thread.currentThread().isDaemon());
    }

    public NamedThreadFactory(String prefix, boolean daemon) {
        if (StringUtils.isBlank((CharSequence)prefix)) {
            prefix = "pool-" + POOL_SEQ.getAndIncrement();
        }
        SecurityManager s = System.getSecurityManager();
        this.prefix = prefix + "-thread-";
        this.daemon = daemon;
        this.group = s == null ? Thread.currentThread().getThreadGroup() : s.getThreadGroup();
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String name = this.prefix + this.threadNo.getAndIncrement();
        Thread thread = new Thread(this.group, runnable, name, 0L);
        thread.setDaemon(this.daemon);
        if (thread.getPriority() != 5) {
            thread.setPriority(5);
        }
        return thread;
    }

    public ThreadGroup getThreadGroup() {
        return this.group;
    }
}

