/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.constrain;

import code.ponfee.commons.constrain.Constraint;
import code.ponfee.commons.constrain.Constraints;
import code.ponfee.commons.constrain.FieldValidator;
import code.ponfee.commons.reflect.ClassUtils;
import code.ponfee.commons.reflect.Fields;
import code.ponfee.commons.reflect.GenericUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MethodValidator
extends FieldValidator {
    private static final Logger LOG = LoggerFactory.getLogger(MethodValidator.class);

    public Object constrain(ProceedingJoinPoint pjp, Constraints validator) throws Throwable {
        Object[] args = pjp.getArgs();
        if (args == null || args.length == 0) {
            return pjp.proceed();
        }
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        String[] argsName = (String[])METHOD_ARGSNAME.getIfPresent((Object)method);
        if (argsName == null) {
            argsName = ClassUtils.getMethodParamNames(method);
            METHOD_ARGSNAME.put((Object)method, (Object)argsName);
        }
        StringBuilder builder = new StringBuilder();
        Class<?>[] paramTypes = method.getParameterTypes();
        Constraint[] csts = validator.value();
        try {
            boolean[] argsNullable = this.argsNullable(args, csts);
            for (Constraint cst : csts) {
                String fieldName;
                Object fieldVal = args[cst.index()];
                Class<Object> fieldType = paramTypes[cst.index()];
                if (argsNullable[cst.index()] && fieldVal == null) continue;
                if (StringUtils.isEmpty((CharSequence)cst.field())) {
                    fieldName = argsName[cst.index()];
                    builder.append(this.constrain(method, fieldName, fieldVal, cst, fieldType));
                } else {
                    if (fieldVal == null) {
                        String msg = args.length == 1 ? "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a;" : "\u53c2\u6570{" + argsName[cst.index()] + "}\u4e0d\u80fd\u4e3a\u7a7a;";
                        throw new IllegalArgumentException(msg);
                    }
                    if (fieldVal instanceof Map) {
                        fieldType = (fieldVal = ((Map)fieldVal).get(cst.field())) == null ? null : fieldVal.getClass();
                        fieldName = argsName[cst.index()] + "[" + cst.field() + "]";
                        builder.append(this.constrain(fieldName, fieldVal, cst, fieldType));
                    } else if (fieldVal instanceof Dictionary) {
                        fieldType = (fieldVal = ((Dictionary)fieldVal).get(cst.field())) == null ? null : fieldVal.getClass();
                        fieldName = argsName[cst.index()] + "[" + cst.field() + "]";
                        builder.append(this.constrain(fieldName, fieldVal, cst, fieldType));
                    } else {
                        String[] ognl;
                        for (String s : ognl = cst.field().split("\\.")) {
                            Field field = ClassUtils.getField(fieldType, s);
                            fieldType = GenericUtils.getFieldActualType(fieldType, field);
                            if (fieldVal == null) continue;
                            fieldVal = Fields.get(fieldVal, field);
                        }
                        fieldName = argsName[cst.index()] + "." + cst.field();
                        builder.append(this.constrain(method, fieldName, fieldVal, cst, fieldType));
                    }
                }
                if (builder.length() <= 500) {
                    continue;
                }
                break;
            }
        }
        catch (IllegalArgumentException | UnsupportedOperationException e) {
            builder.append(e.getMessage());
        }
        catch (Exception e) {
            LOG.error("\u53c2\u6570\u7ea6\u675f\u6821\u9a8c\u5f02\u5e38", (Throwable)e);
            builder.append("\u53c2\u6570\u7ea6\u675f\u6821\u9a8c\u5f02\u5e38\uff1a").append(e.getMessage());
        }
        return builder.length() == 0 ? pjp.proceed() : this.processError(builder, method, args);
    }

    private boolean[] argsNullable(Object[] args, Constraint[] csts) {
        HashSet<String> set = new HashSet<String>(csts.length);
        boolean[] isArgsNullable = new boolean[args.length];
        Arrays.fill(isArgsNullable, false);
        for (Constraint cst : csts) {
            String key = "index=" + cst.index() + ", field=\"" + cst.field() + "\"";
            if (!set.add(key)) {
                throw new RuntimeException("\u914d\u7f6e\u9519\u8bef\uff0c\u91cd\u590d\u6821\u9a8c[" + key + "]");
            }
            if (cst.index() > args.length - 1) {
                throw new RuntimeException("\u914d\u7f6e\u9519\u8bef\uff0c\u4e0b\u6807\u8d85\u51fa[index=" + cst.index() + "]");
            }
            if (!StringUtils.isEmpty((CharSequence)cst.field()) || cst.notNull()) continue;
            isArgsNullable[cst.index()] = true;
        }
        return isArgsNullable;
    }
}

