/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.data.lookup;

import code.ponfee.commons.base.Initializable;
import code.ponfee.commons.base.Releasable;
import code.ponfee.commons.data.NamedDataSource;
import code.ponfee.commons.data.lookup.DataSourceLookup;
import code.ponfee.commons.data.lookup.MultipleDataSourceContext;
import code.ponfee.commons.exception.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.jdbc.datasource.AbstractDataSource;

public class MultipleCachedDataSource
extends AbstractDataSource
implements DataSourceLookup,
Initializable,
Closeable {
    private final Map<String, DataSource> naturalDataSources;
    private final DataSource defaultDataSource;
    private final Cache<String, DataSource> adoptedDataSources;

    public MultipleCachedDataSource(int expireSeconds, NamedDataSource dataSource) {
        this(expireSeconds, dataSource.getName(), dataSource.getDataSource(), new NamedDataSource[0]);
    }

    public MultipleCachedDataSource(int expireSeconds, NamedDataSource ... dataSources) {
        this(expireSeconds, dataSources[0].getName(), dataSources[0].getDataSource(), (NamedDataSource[])ArrayUtils.subarray((Object[])dataSources, (int)1, (int)dataSources.length));
    }

    public MultipleCachedDataSource(int expireSeconds, String defaultName, DataSource defaultDataSource, NamedDataSource ... othersDataSource) {
        this.defaultDataSource = defaultDataSource;
        this.naturalDataSources = ImmutableMap.copyOf(MultipleDataSourceContext.process(defaultName, defaultDataSource, othersDataSource));
        this.adoptedDataSources = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofSeconds(expireSeconds)).maximumSize(8192L).removalListener(notification -> {
            try {
                Releasable.release(notification.getValue());
            }
            catch (Exception e) {
                Throwables.console(e);
            }
        }).build();
    }

    public synchronized boolean addIfAbsent(String dataSourceName, Supplier<DataSource> supplier) {
        if (this.existsDatasourceName(dataSourceName)) {
            return false;
        }
        this.add(dataSourceName, supplier.get());
        return true;
    }

    public synchronized boolean addIfAbsent(String dataSourceName, DataSource datasource) {
        if (this.existsDatasourceName(dataSourceName)) {
            return false;
        }
        this.add(dataSourceName, datasource);
        return true;
    }

    public synchronized void add(NamedDataSource ds) {
        this.add(ds.getName(), ds.getDataSource());
    }

    public synchronized void add(@Nonnull String dataSourceName, @Nonnull DataSource datasource) {
        if (this.existsDatasourceName(dataSourceName)) {
            throw new IllegalArgumentException("Duplicated datasource name: " + dataSourceName);
        }
        this.adoptedDataSources.put((Object)dataSourceName, (Object)datasource);
        MultipleDataSourceContext.add(dataSourceName);
    }

    public synchronized void remove(String dataSourceName) {
        if (this.naturalDataSources.containsKey(dataSourceName)) {
            throw new UnsupportedOperationException("Local datasource cannot remove: " + dataSourceName);
        }
        this.adoptedDataSources.invalidate((Object)dataSourceName);
        MultipleDataSourceContext.remove(dataSourceName);
    }

    public Connection getConnection() throws SQLException {
        return this.determineTargetDataSource().getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.determineTargetDataSource().getConnection(username, password);
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        return this.determineTargetDataSource().unwrap(iface);
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this) || this.determineTargetDataSource().isWrapperFor(iface);
    }

    @Override
    public DataSource lookupDataSource(String name) {
        DataSource dataSource = this.naturalDataSources.get(name);
        return dataSource != null ? dataSource : (DataSource)this.adoptedDataSources.getIfPresent((Object)name);
    }

    @Override
    public void init() {
        this.naturalDataSources.forEach((name, ds) -> Initializable.init(ds));
    }

    @Override
    public void close() {
        this.naturalDataSources.forEach((name, ds) -> {
            try {
                Releasable.release(ds);
            }
            catch (Exception e) {
                Throwables.console(e);
            }
        });
        this.adoptedDataSources.asMap().forEach((name, ds) -> {
            try {
                Releasable.release(ds);
            }
            catch (Exception e) {
                Throwables.console(e);
            }
        });
    }

    private DataSource determineTargetDataSource() {
        DataSource dataSource;
        String lookupKey = MultipleDataSourceContext.get();
        DataSource dataSource2 = dataSource = lookupKey == null ? this.defaultDataSource : this.lookupDataSource(lookupKey);
        if (dataSource == null) {
            throw new IllegalStateException("Cannot found DataSource by name [" + lookupKey + "]");
        }
        return dataSource;
    }

    private boolean existsDatasourceName(String name) {
        return this.naturalDataSources.containsKey(name) || this.adoptedDataSources.getIfPresent((Object)name) != null;
    }
}

