/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.date;

import code.ponfee.commons.date.Dates;
import com.google.common.base.Strings;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;

@ThreadSafe
public class JavaUtilDateFormat
extends DateFormat {
    private static final long serialVersionUID = 6837172676882367405L;
    private static final DateTimeFormatter DATE_TO_STRING_FORMAT = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss zzz yyyy", Locale.ROOT);
    public static final Pattern DATE_TO_STRING_PATTERN = Pattern.compile("^(Sun|Mon|Tue|Wed|Thu|Fri|Sat) [A-Z][a-z]{2} \\d{2} \\d{2}:\\d{2}:\\d{2} CST \\d{4}$");
    public static final Pattern DATE_TIMESTAMP_PATTERN = Pattern.compile("^0|[1-9]\\d*$");
    public static final FastDateFormat PATTERN_11 = FastDateFormat.getInstance((String)"yyyyMM");
    public static final FastDateFormat PATTERN_12 = FastDateFormat.getInstance((String)"yyyy-MM");
    public static final FastDateFormat PATTERN_13 = FastDateFormat.getInstance((String)"yyyy/MM");
    public static final FastDateFormat PATTERN_21 = FastDateFormat.getInstance((String)"yyyyMMdd");
    public static final FastDateFormat PATTERN_22 = FastDateFormat.getInstance((String)"yyyy-MM-dd");
    public static final FastDateFormat PATTERN_23 = FastDateFormat.getInstance((String)"yyyy/MM/dd");
    public static final FastDateFormat PATTERN_31 = FastDateFormat.getInstance((String)"yyyyMMddHHmmss");
    public static final FastDateFormat PATTERN_32 = FastDateFormat.getInstance((String)"yyyyMMddHHmmssSSS");
    public static final FastDateFormat PATTERN_41 = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
    public static final FastDateFormat PATTERN_42 = FastDateFormat.getInstance((String)"yyyy/MM/dd HH:mm:ss");
    public static final FastDateFormat PATTERN_43 = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss");
    public static final FastDateFormat PATTERN_44 = FastDateFormat.getInstance((String)"yyyy/MM/dd'T'HH:mm:ss");
    public static final FastDateFormat PATTERN_51 = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss.SSS");
    public static final FastDateFormat PATTERN_52 = FastDateFormat.getInstance((String)"yyyy/MM/dd HH:mm:ss.SSS");
    public static final FastDateFormat PATTERN_53 = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSS");
    public static final FastDateFormat PATTERN_54 = FastDateFormat.getInstance((String)"yyyy/MM/dd'T'HH:mm:ss.SSS");
    public static final FastDateFormat PATTERN_61 = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss.SSS'Z'");
    public static final FastDateFormat PATTERN_62 = FastDateFormat.getInstance((String)"yyyy/MM/dd HH:mm:ss.SSS'Z'");
    public static final FastDateFormat PATTERN_63 = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    public static final FastDateFormat PATTERN_64 = FastDateFormat.getInstance((String)"yyyy/MM/dd'T'HH:mm:ss.SSS'Z'");
    public static final FastDateFormat PATTERN_71 = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss.SSSX");
    public static final FastDateFormat PATTERN_72 = FastDateFormat.getInstance((String)"yyyy/MM/dd HH:mm:ss.SSSX");
    public static final FastDateFormat PATTERN_73 = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSX");
    public static final FastDateFormat PATTERN_74 = FastDateFormat.getInstance((String)"yyyy/MM/dd'T'HH:mm:ss.SSSX");
    public static final JavaUtilDateFormat DEFAULT = new JavaUtilDateFormat("yyyy-MM-dd HH:mm:ss");
    private final FastDateFormat backstopFormat;

    public JavaUtilDateFormat(String pattern) {
        this(pattern, Locale.getDefault());
    }

    public JavaUtilDateFormat(String pattern, Locale locale) {
        this(FastDateFormat.getInstance((String)pattern, (Locale)locale));
    }

    public JavaUtilDateFormat(FastDateFormat format) {
        this.backstopFormat = format;
        super.setCalendar(Calendar.getInstance(format.getTimeZone(), format.getLocale()));
        NumberFormat numberFormat = NumberFormat.getIntegerInstance(format.getLocale());
        numberFormat.setGroupingUsed(false);
        super.setNumberFormat(numberFormat);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        return this.backstopFormat.format((Object)date, toAppendTo, fieldPosition);
    }

    @Override
    public Date parse(String source, ParsePosition pos) {
        Objects.requireNonNull(pos);
        if (pos.getIndex() < 0) {
            throw new IllegalArgumentException("Invalid parse position: " + pos.getIndex());
        }
        if (StringUtils.isEmpty((CharSequence)source) || source.length() <= pos.getIndex()) {
            return null;
        }
        String date = source.substring(pos.getIndex());
        try {
            return this.parse(date);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid date format: " + source + ", " + pos.getIndex() + ", " + date);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid date format: " + source + ", " + pos.getIndex() + ", " + date, e);
        }
    }

    public LocalDateTime parseToLocalDateTime(String source, ParsePosition pos) {
        Date date = this.parse(source, pos);
        return date == null ? null : Dates.toLocalDateTime(date);
    }

    @Override
    public Date parse(String source) throws ParseException {
        if (StringUtils.isEmpty((CharSequence)source)) {
            return null;
        }
        int length = source.length();
        if (length >= 20 && source.endsWith("Z")) {
            if (length < 24) {
                source = JavaUtilDateFormat.padding(source) + "Z";
            }
            if (JavaUtilDateFormat.hasTSeparator(source)) {
                return (JavaUtilDateFormat.isCrossbar(source) ? PATTERN_63 : PATTERN_64).parse(source);
            }
            return (JavaUtilDateFormat.isCrossbar(source) ? PATTERN_61 : PATTERN_62).parse(source);
        }
        switch (length) {
            case 6: {
                return PATTERN_11.parse(source);
            }
            case 7: {
                return (JavaUtilDateFormat.isCrossbar(source) ? PATTERN_12 : PATTERN_13).parse(source);
            }
            case 8: {
                return PATTERN_21.parse(source);
            }
            case 10: {
                char separator = source.charAt(4);
                if (separator == '-') {
                    return PATTERN_22.parse(source);
                }
                if (separator == '/') {
                    return PATTERN_23.parse(source);
                }
                if (!DATE_TIMESTAMP_PATTERN.matcher(source).matches()) break;
                return new Date(Long.parseLong(source) * 1000L);
            }
            case 13: {
                if (!DATE_TIMESTAMP_PATTERN.matcher(source).matches()) break;
                return new Date(Long.parseLong(source));
            }
            case 14: {
                return PATTERN_31.parse(source);
            }
            case 19: {
                if (JavaUtilDateFormat.hasTSeparator(source)) {
                    return (JavaUtilDateFormat.isCrossbar(source) ? PATTERN_43 : PATTERN_44).parse(source);
                }
                return (JavaUtilDateFormat.isCrossbar(source) ? PATTERN_41 : PATTERN_42).parse(source);
            }
            case 17: {
                return PATTERN_32.parse(source);
            }
            case 23: {
                if (JavaUtilDateFormat.hasTSeparator(source)) {
                    return (JavaUtilDateFormat.isCrossbar(source) ? PATTERN_53 : PATTERN_54).parse(source);
                }
                return (JavaUtilDateFormat.isCrossbar(source) ? PATTERN_51 : PATTERN_52).parse(source);
            }
            case 26: 
            case 29: {
                if (JavaUtilDateFormat.hasTSeparator(source)) {
                    return (JavaUtilDateFormat.isCrossbar(source) ? PATTERN_73 : PATTERN_74).parse(source);
                }
                return (JavaUtilDateFormat.isCrossbar(source) ? PATTERN_71 : PATTERN_72).parse(source);
            }
            case 28: {
                if (!JavaUtilDateFormat.isCST(source)) break;
                return Dates.toDate(LocalDateTime.parse(source, DATE_TO_STRING_FORMAT));
            }
        }
        return this.backstopFormat.parse(source);
    }

    public LocalDateTime parseToLocalDateTime(String source) throws ParseException {
        Date date = this.parse(source);
        return date == null ? null : Dates.toLocalDateTime(date);
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return this.parse(source, pos);
    }

    @Override
    public Object parseObject(String source) throws ParseException {
        return this.parse(source);
    }

    @Override
    public int hashCode() {
        return this.backstopFormat.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JavaUtilDateFormat)) {
            return false;
        }
        JavaUtilDateFormat other = (JavaUtilDateFormat)obj;
        return this.backstopFormat.equals((Object)other.backstopFormat);
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object obj) {
        return this.backstopFormat.formatToCharacterIterator(obj);
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    @Deprecated
    public void setCalendar(Calendar newCalendar) {
        if (!Objects.equals(newCalendar, super.getCalendar())) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    @Deprecated
    public void setNumberFormat(NumberFormat newNumberFormat) {
        if (!Objects.equals(newNumberFormat, super.getNumberFormat())) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    @Deprecated
    public void setTimeZone(TimeZone zone) {
        if (!Objects.equals(zone, super.getTimeZone())) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    @Deprecated
    public void setLenient(boolean lenient) {
        if (lenient != super.isLenient()) {
            throw new UnsupportedOperationException();
        }
    }

    static boolean isCrossbar(String str) {
        return str.charAt(4) == '-';
    }

    static boolean hasTSeparator(String str) {
        return str.charAt(10) == 'T';
    }

    static boolean isCST(String str) {
        return DATE_TO_STRING_PATTERN.matcher(str).matches();
    }

    static String padding(String source) {
        String[] array = source.split("[\\.Z]");
        return array[0] + "." + (array.length == 1 ? "000" : Strings.padEnd((String)array[1], (int)3, (char)'0'));
    }
}

