/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.export;

import code.ponfee.commons.export.DataExporter;
import code.ponfee.commons.export.Table;
import code.ponfee.commons.export.Thead;
import code.ponfee.commons.reflect.Fields;
import code.ponfee.commons.tree.BaseNode;
import code.ponfee.commons.tree.FlatNode;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class AbstractDataExporter<T>
implements DataExporter<T> {
    public static final int AWAIT_TIME_MILLIS = 47;
    private boolean empty = true;
    private String name;

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public void close() {
    }

    public final void nonEmpty() {
        this.empty = false;
    }

    public final AbstractDataExporter<T> setName(String name) {
        this.name = name;
        return this;
    }

    public final String getName() {
        return this.name;
    }

    protected final <E> void rollingTbody(Table<E> table, BiConsumer<Object[], Integer> action) {
        try {
            Function<E, Object[]> converter = table.getConverter();
            if (converter != null) {
                int i = 0;
                while (table.isNotEnd()) {
                    E data = table.getRow(47L);
                    if (data == null) continue;
                    action.accept(converter.apply(data), i++);
                }
            } else {
                String[] fields = (String[])table.getThead().stream().filter(FlatNode::isLeaf).map(f -> ((Thead)f.getAttach()).getField()).toArray(String[]::new);
                int i = 0;
                while (table.isNotEnd()) {
                    E data = table.getRow(47L);
                    if (data == null) continue;
                    Object[] array = data instanceof Object[] ? (Object[])data : (data.getClass().isArray() ? AbstractDataExporter.covariantArray(data) : (data instanceof Collection ? AbstractDataExporter.collection2array((Collection)data) : (data instanceof Iterable ? AbstractDataExporter.iterable2array((Iterable)data) : (data instanceof Iterator ? AbstractDataExporter.iterator2array((Iterator)data) : (data instanceof Map ? AbstractDataExporter.map2array((Map)data) : (data instanceof Dictionary ? AbstractDataExporter.dictionary2array((Dictionary)data) : AbstractDataExporter.bean2array(data, fields)))))));
                    action.accept(array, i++);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    protected final List<Thead> getLeafThead(List<FlatNode<Integer, Thead>> thead) {
        return thead.stream().filter(FlatNode::isLeaf).map(BaseNode::getAttach).collect(Collectors.toList());
    }

    private static Object[] collection2array(Collection<?> coll) {
        Object[] array = new Object[coll.size()];
        int i = 0;
        for (Object obj : coll) {
            array[i++] = obj;
        }
        return array;
    }

    private static Object[] iterable2array(Iterable<?> iterable) {
        LinkedList list = new LinkedList();
        iterable.forEach(list::add);
        return list.toArray();
    }

    private static Object[] iterator2array(Iterator<?> iter) {
        LinkedList list = new LinkedList();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list.toArray();
    }

    private static Object[] covariantArray(Object array0) {
        int size = Array.getLength(array0);
        Object[] array = new Object[size];
        for (int i = 0; i < size; ++i) {
            array[i] = Array.get(array0, i);
        }
        return array;
    }

    private static Object[] map2array(Map<?, ?> map) {
        LinkedList list = new LinkedList();
        map.forEach((k, v) -> list.add(v));
        return list.toArray();
    }

    private static Object[] dictionary2array(Dictionary<?, ?> dic) {
        LinkedList list = new LinkedList();
        Enumeration<?> enu = dic.elements();
        while (enu.hasMoreElements()) {
            list.add(enu.nextElement());
        }
        return list.toArray();
    }

    private static Object[] bean2array(Object bean, String[] fields) {
        int size = fields.length;
        Object[] array = new Object[size];
        for (int i = 0; i < size; ++i) {
            array[i] = Fields.get(bean, fields[i]);
        }
        return array;
    }
}

