/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.export;

import code.ponfee.commons.export.AbstractDataExporter;
import code.ponfee.commons.export.Table;
import code.ponfee.commons.export.Thead;
import code.ponfee.commons.math.Numbers;
import code.ponfee.commons.tree.FlatNode;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;

public class ConsoleExporter
extends AbstractDataExporter<String> {
    public static final String HORIZON = "\n\n-------------------------------------------------------\n\n";
    public static final String ELLIPSIS_STR = "...";
    public static final int ELLIPSIS_LEN = "...".length();
    protected final Appendable out;
    protected final int maxColumnWidth;
    protected final boolean hasLineSeparator;

    public ConsoleExporter(Appendable out) {
        this(out, 36, false);
    }

    public ConsoleExporter(Appendable out, int maxColumnWidth, boolean rowSeparator) {
        this.out = out;
        this.maxColumnWidth = Math.max(maxColumnWidth, ELLIPSIS_LEN + 1);
        this.hasLineSeparator = rowSeparator;
    }

    @Override
    public <E> void build(Table<E> table) {
        List<FlatNode<Integer, Thead>> flats = table.getThead();
        if (flats == null || flats.isEmpty()) {
            throw new IllegalArgumentException("thead can't be null");
        }
        try {
            this.horizon();
            List<Column> columns = ConsoleExporter.union(new Column(new Thead("#")), this.getLeafThead(table.getThead()).stream().map(x$0 -> new Column((Thead)x$0)).collect(Collectors.toList()));
            LongAdder rowCount = new LongAdder();
            this.rollingTbody(table, (data, i) -> {
                Column first = (Column)columns.get(0);
                String rowNumber = Integer.toString(i + 1);
                first.values.add(rowNumber);
                first.width = Numbers.bounds(rowNumber.length(), first.width, this.maxColumnWidth);
                int m = ((Object[])data).length;
                for (int colIdx = 0; colIdx < m; ++colIdx) {
                    Column column = (Column)columns.get(colIdx + 1);
                    String value = Objects.toString(data[colIdx], "");
                    column.values.add(value);
                    column.width = Numbers.bounds(value.length(), column.width, this.maxColumnWidth);
                }
                rowCount.increment();
            });
            int rowWidth = columns.stream().mapToInt(e -> ((Column)e).width + 3).sum() + 1;
            String caption = Objects.toString(table.getCaption(), "");
            this.append("+-").append('-', rowWidth - 4).append("-+").newLine();
            this.append("| ").center(caption, rowWidth - 4).append(" |").newLine();
            String separator = "+-" + columns.stream().map(e -> Strings.repeat((String)"-", (int)((Column)e).width)).collect(Collectors.joining("-+-")) + "-+";
            this.append(separator).newLine();
            for (Column col : columns) {
                this.append("| ").center(col.getName(), col.width).append(' ');
            }
            this.append('|').newLine();
            this.append(separator).newLine();
            int n = rowCount.intValue();
            for (int rowIdx = 0; rowIdx < n; ++rowIdx) {
                if (this.hasLineSeparator && rowIdx > 0) {
                    this.append(separator).newLine();
                }
                for (Column col : columns) {
                    this.append("| ").append((String)col.values.get(rowIdx), col.width).append(' ');
                }
                this.append('|').newLine();
            }
            this.append(separator).newLine();
            this.nonEmpty();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public String export() {
        return this.out.toString();
    }

    private ConsoleExporter horizon() throws IOException {
        if (!this.isEmpty()) {
            this.out.append(HORIZON);
        }
        return this;
    }

    private ConsoleExporter append(char c) throws IOException {
        this.out.append(c);
        return this;
    }

    private ConsoleExporter append(char c, int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            this.out.append(c);
        }
        return this;
    }

    private ConsoleExporter append(CharSequence text) throws IOException {
        this.out.append(text);
        return this;
    }

    private ConsoleExporter append(String text, int width) throws IOException {
        int padding = width - text.length();
        if (padding >= 0) {
            this.append(text).append(' ', padding);
        } else {
            this.out.append(text, 0, width - ELLIPSIS_LEN);
            this.out.append(ELLIPSIS_STR);
        }
        return this;
    }

    private ConsoleExporter center(String text, int width) throws IOException {
        int padding = width - text.length();
        if (padding >= 0) {
            this.append(' ', padding / 2).append(text).append(' ', (padding + 1) / 2);
        } else {
            this.out.append(text, 0, width - ELLIPSIS_LEN);
            this.out.append(ELLIPSIS_STR);
        }
        return this;
    }

    private void newLine() throws IOException {
        this.out.append('\n');
    }

    private static <T> List<T> union(T first, Collection<T> coll) {
        ArrayList<T> list = new ArrayList<T>(coll.size() + 1);
        list.add(first);
        list.addAll(coll);
        return list;
    }

    private class Column
    extends Thead {
        private static final long serialVersionUID = -5764311953058980984L;
        private final List<String> values;
        private int width;

        public Column(Thead th) {
            super(th.getName(), th.getTmeta(), th.getField());
            this.values = new ArrayList<String>();
            this.width = Math.min(th.getName().length(), ConsoleExporter.this.maxColumnWidth);
        }
    }
}

