/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.export;

import code.ponfee.commons.export.CsvWriteExporter;
import code.ponfee.commons.io.ByteOrderMarks;
import code.ponfee.commons.io.WrappedBufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class CsvFileExporter
extends CsvWriteExporter {
    public CsvFileExporter(String filePath, boolean withBom) throws IOException {
        this(new File(filePath), StandardCharsets.UTF_8, withBom);
    }

    public CsvFileExporter(File file, Charset charset, boolean withBom) throws IOException {
        super(CsvFileExporter.createWriter(file, charset, withBom));
    }

    public CsvFileExporter(File file, Charset charset, boolean withBom, char csvSeparator) throws IOException {
        super(CsvFileExporter.createWriter(file, charset, withBom), csvSeparator);
    }

    private static Writer createWriter(File file, Charset charset, boolean withBom) throws IOException {
        byte[] bom;
        WrappedBufferedWriter writer = new WrappedBufferedWriter(file, charset);
        if (withBom && (bom = ByteOrderMarks.get(charset)) != null) {
            writer.write(bom);
        }
        return writer;
    }
}

