/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.export;

import code.ponfee.commons.export.AbstractCsvExporter;
import code.ponfee.commons.io.ByteOrderMarks;
import code.ponfee.commons.io.WrappedBufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public class CsvStringExporter
extends AbstractCsvExporter<String> {
    public CsvStringExporter() {
        this(8192);
    }

    public CsvStringExporter(int capacity) {
        super(new StringBuilder(capacity));
    }

    public CsvStringExporter(int capacity, char csvSeparator) {
        super(new StringBuilder(capacity), csvSeparator);
    }

    @Override
    public String export() {
        return this.csv.toString();
    }

    public void write(String filePath, Charset charset, boolean withBom) {
        File file = new File(filePath);
        try (WrappedBufferedWriter writer = new WrappedBufferedWriter(file, charset);){
            byte[] bom;
            if (withBom && (bom = ByteOrderMarks.get(charset)) != null) {
                writer.write(bom);
            }
            writer.append((StringBuilder)this.csv);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

