/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.extract;

import code.ponfee.commons.extract.ExtractableDataSource;
import code.ponfee.commons.extract.ValidateResult;
import code.ponfee.commons.util.Holder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class DataExtractor {
    protected final ExtractableDataSource dataSource;
    protected final String[] headers;
    protected volatile boolean end = false;

    protected DataExtractor(ExtractableDataSource dataSource, String[] headers) {
        this.dataSource = dataSource;
        this.headers = headers;
    }

    public abstract void extract(BiConsumer<Integer, String[]> var1) throws IOException;

    public final List<String[]> extract() throws IOException {
        LinkedList<String[]> list = new LinkedList<String[]>();
        this.extract((rowNumber, data) -> list.add((String[])data));
        return list;
    }

    public final List<String[]> extract(int count) throws IOException {
        ArrayList<String[]> result = new ArrayList<String[]>(count);
        this.extract((rowNum, row) -> {
            if (rowNum >= count) {
                this.end = true;
                return;
            }
            result.add((String[])row);
        });
        return result;
    }

    public final void extract(int batchSize, Consumer<List<String[]>> action) throws IOException {
        Holder holder = Holder.of(new ArrayList(batchSize));
        this.extract((rowNumber, data) -> {
            List list = (List)holder.get();
            list.add(data);
            if (list.size() == batchSize) {
                action.accept(list);
                holder.set(new ArrayList(batchSize));
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)holder.get())) {
            action.accept(holder.get());
        }
    }

    public final ValidateResult verify(BiFunction<Integer, String[], String> validator) throws IOException {
        ValidateResult result = new ValidateResult();
        this.extract((rowNumber, data) -> {
            String error = (String)validator.apply((Integer)rowNumber, (String[])data);
            if (StringUtils.isBlank((CharSequence)error)) {
                result.addData((String[])data);
            } else {
                result.addError(new StringBuilder(error.length() + 12).append("\u7b2c[").append(rowNumber + 1).append("]\u884c\u9519\u8bef\uff1a").append(error).toString());
            }
        });
        return result;
    }

    protected boolean isNotEmpty(String[] data) {
        if (data == null || data.length == 0) {
            return false;
        }
        for (String str : data) {
            if (!StringUtils.isNotBlank((CharSequence)str)) continue;
            return true;
        }
        return false;
    }
}

