/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.extract;

import code.ponfee.commons.extract.CsvExtractor;
import code.ponfee.commons.extract.DataExtractor;
import code.ponfee.commons.extract.ExcelExtractor;
import code.ponfee.commons.extract.ExtractableDataSource;
import code.ponfee.commons.extract.streaming.StreamingExcelExtractor;
import code.ponfee.commons.http.ContentType;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.EnumUtils;

public class DataExtractorBuilder {
    private static final List<String> EXCEL_EXTENSION = ImmutableList.of((Object)"xlsx", (Object)"xls");
    private static final List<String> CSV_EXTENSION = ImmutableList.of((Object)"csv", (Object)"log", (Object)"txt");
    private final Object dataSource;
    private final String fileName;
    private final String contentType;
    private String[] headers;
    private int startRow = 0;
    private int sheetIndex = 0;
    private boolean streaming = true;
    private CSVFormat csvFormat;
    private Charset charset;

    private DataExtractorBuilder(Object dataSource, String fileName, String contentType) {
        this.dataSource = dataSource;
        this.fileName = fileName;
        this.contentType = contentType;
    }

    public static DataExtractorBuilder newBuilder(InputStream dataSource, String fileName, String contentType) {
        return new DataExtractorBuilder(dataSource, fileName, contentType);
    }

    public static DataExtractorBuilder newBuilder(String path) {
        return DataExtractorBuilder.newBuilder(new File(path));
    }

    public static DataExtractorBuilder newBuilder(File dataSource) {
        String fileName = dataSource.getName();
        return new DataExtractorBuilder(dataSource, fileName, FilenameUtils.getExtension((String)fileName));
    }

    public DataExtractorBuilder headers(String[] headers) {
        this.headers = headers;
        return this;
    }

    public DataExtractorBuilder startRow(int startRow) {
        this.startRow = startRow;
        return this;
    }

    public DataExtractorBuilder sheetIndex(int sheetIndex) {
        this.sheetIndex = sheetIndex;
        return this;
    }

    public DataExtractorBuilder streaming(boolean streaming) {
        this.streaming = streaming;
        return this;
    }

    public DataExtractorBuilder csvFormat(CSVFormat csvFormat) {
        this.csvFormat = csvFormat;
        return this;
    }

    public DataExtractorBuilder charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public DataExtractor build() {
        String extension = FilenameUtils.getExtension((String)this.fileName).toLowerCase();
        if (ContentType.TEXT_PLAIN.value().equalsIgnoreCase(this.contentType) || CSV_EXTENSION.contains(extension)) {
            ExtractableDataSource ds = new ExtractableDataSource(this.dataSource);
            return new CsvExtractor(ds, this.headers, this.csvFormat, this.startRow, this.charset);
        }
        if (EXCEL_EXTENSION.contains(extension)) {
            ExtractableDataSource ds = new ExtractableDataSource(this.dataSource);
            ExcelExtractor.ExcelType type = (ExcelExtractor.ExcelType)EnumUtils.getEnumIgnoreCase(ExcelExtractor.ExcelType.class, (String)extension);
            return this.streaming ? new StreamingExcelExtractor(ds, this.headers, this.startRow, type, this.sheetIndex) : new ExcelExtractor(ds, this.headers, this.startRow, type, this.sheetIndex);
        }
        throw new RuntimeException("File content type not supported: " + this.fileName);
    }
}

