/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.extract.streaming.xls;

import code.ponfee.commons.extract.streaming.xls.HSSFStreamingWorkbook;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.ArrayUtils;

public class HSSFStreamingReader {
    private int rowCacheSize = 0;
    private int[] sheetIndexs;
    private String[] sheetNames;

    private HSSFStreamingReader() {
    }

    public static HSSFStreamingReader create() {
        return new HSSFStreamingReader();
    }

    public static HSSFStreamingReader create(int rowCacheSize, int ... sheetIndexs) {
        Preconditions.checkArgument((rowCacheSize > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)ArrayUtils.isNotEmpty((int[])sheetIndexs));
        HSSFStreamingReader reader = new HSSFStreamingReader();
        reader.rowCacheSize = rowCacheSize;
        reader.sheetIndexs = sheetIndexs;
        return reader;
    }

    public static HSSFStreamingReader create(int rowCacheSize, String ... sheetNames) {
        Preconditions.checkArgument((rowCacheSize > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)ArrayUtils.isNotEmpty((Object[])sheetNames));
        HSSFStreamingReader reader = new HSSFStreamingReader();
        reader.rowCacheSize = rowCacheSize;
        reader.sheetNames = sheetNames;
        return reader;
    }

    public HSSFStreamingWorkbook open(InputStream input, Executor executor) {
        return new HSSFStreamingWorkbook(input, this.rowCacheSize, this.sheetIndexs, this.sheetNames, executor);
    }

    public HSSFStreamingWorkbook open(File file, Executor executor) {
        try {
            return this.open(new FileInputStream(file), executor);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public HSSFStreamingWorkbook open(String filePath, Executor executor) {
        return this.open(new File(filePath), executor);
    }
}

