/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.http;

import code.ponfee.commons.collect.Maps;
import code.ponfee.commons.util.ObjectUtils;
import code.ponfee.commons.util.URLCodes;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class HttpParams {
    public static Map<String, String[]> parseUrlParams(String url) {
        return HttpParams.parseUrlParams(url, "UTF-8");
    }

    public static Map<String, String[]> parseUrlParams(String url, String charset) {
        int idx = url.indexOf(63);
        return idx == -1 ? Collections.emptyMap() : HttpParams.parseParams(url.substring(idx + 1), charset);
    }

    public static Map<String, String[]> parseParams(String queryString) {
        return HttpParams.parseParams(queryString, "UTF-8");
    }

    public static Map<String, String[]> parseParams(String queryString, String encoding) {
        if (queryString == null || queryString.length() == 0) {
            return Collections.emptyMap();
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        LinkedHashMap<String, String[]> params = new LinkedHashMap<String, String[]>();
        for (String param : queryString.split("&")) {
            String[] kv = param.split("=", 2);
            HttpParams.putParam(params, kv[0], kv.length == 1 ? "" : URLCodes.decodeURIComponent(kv[1], encoding));
        }
        return params;
    }

    public static String buildParams(Map<String, ?> params) {
        return HttpParams.buildParams(params, "UTF-8");
    }

    public static String buildParams(Map<String, ?> params, String encoding) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            String[] values;
            Object value = entry.getValue();
            if (value != null && value.getClass().isArray()) {
                values = new String[Array.getLength(value)];
                int length = values.length;
                for (int i = 0; i < length; ++i) {
                    values[i] = Objects.toString(Array.get(value, i), "");
                }
            } else {
                values = new String[]{Objects.toString(entry.getValue(), "")};
            }
            for (String val : values) {
                builder.append(entry.getKey()).append("=").append(URLCodes.encodeURIComponent(val, encoding)).append("&");
            }
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    public static String buildUrlPath(String url, String encoding, Map<String, ?> params) {
        if (params == null || params.isEmpty()) {
            return url;
        }
        return url + (url.indexOf(63) == -1 ? (char)'?' : '&') + HttpParams.buildParams(params, encoding);
    }

    public static String buildUrlPath(String url, String encoding, Object ... params) {
        return HttpParams.buildUrlPath(url, encoding, Maps.toMap(params));
    }

    public static String buildSigning(Map<String, ?> params) {
        return HttpParams.buildSigning(params, "", null);
    }

    public static String buildSigning(Map<String, ?> params, String[] excludes) {
        return HttpParams.buildSigning(params, "", excludes);
    }

    public static String buildSigning(Map<String, ?> params, String wrapChar, String[] excludes) {
        List filter = excludes == null || excludes.length == 0 ? Collections.emptyList() : Arrays.asList(excludes);
        TreeMap<String, String> signingMap = new TreeMap<String, String>();
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            if (filter.contains(entry.getKey()) || !StringUtils.isNotEmpty((CharSequence)Objects.toString(entry.getValue(), null))) continue;
            signingMap.put(entry.getKey(), entry.getValue().toString());
        }
        StringBuilder signing = new StringBuilder();
        for (Map.Entry entry : signingMap.entrySet()) {
            signing.append((String)entry.getKey()).append('=').append(wrapChar).append((String)entry.getValue()).append(wrapChar).append('&');
        }
        if (signing.length() > 0) {
            signing.setLength(signing.length() - 1);
        }
        return signing.toString();
    }

    public static String buildForm(String url, Map<String, ?> params) {
        StringBuilder form = new StringBuilder(256);
        String formName = ObjectUtils.uuid32();
        form.append("<form action=\"").append(url).append("\" name=\"").append(formName).append("\" method=\"post\">");
        for (Map.Entry<String, ?> param : params.entrySet()) {
            Object value = param.getValue();
            if (value != null && value.getClass().isArray()) {
                int length = Array.getLength(value);
                for (int i = 0; i < length; ++i) {
                    HttpParams.buildInputElement(form, param.getKey(), Array.get(value, i));
                }
                continue;
            }
            HttpParams.buildInputElement(form, param.getKey(), value);
        }
        return form.append("</form><script>document.forms['").append(formName).append("'].submit();</script>").toString();
    }

    public static String buildSoap(String method, String namespace, Map<String, ?> params) {
        StringBuilder sb = new StringBuilder();
        sb.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:ns=\"").append(namespace).append("\">");
        sb.append("<soapenv:Body>");
        sb.append("<ns:").append(method).append(">");
        if (MapUtils.isNotEmpty(params)) {
            params.forEach((k, v) -> sb.append("<").append((String)k).append(">").append(Objects.toString(v, "")).append("</").append((String)k).append(">"));
        }
        sb.append("</ns:").append(method).append(">");
        sb.append("</soapenv:Body>");
        sb.append("</soapenv:Envelope>");
        return sb.toString();
    }

    private static void putParam(Map<String, String[]> params, String name, String value) {
        Object[] oldValues = params.get(name);
        if (oldValues == null) {
            params.put(name, new String[]{value});
        } else {
            params.put(name, (String[])ArrayUtils.add((Object[])oldValues, (Object)value));
        }
    }

    private static void buildInputElement(StringBuilder form, String name, Object value) {
        form.append("<input type=\"hidden\" name=\"").append(name).append("\" value=\"").append(Objects.toString(value, "")).append("\" />");
    }
}

