/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.jce;

import code.ponfee.commons.jce.ECParameters;
import code.ponfee.commons.jce.security.ECDSASigner;
import code.ponfee.commons.jce.security.RSACryptor;
import code.ponfee.commons.jce.security.RSAPrivateKeys;
import code.ponfee.commons.jce.security.RSAPublicKeys;
import code.ponfee.commons.jce.sm.SM2;
import code.ponfee.commons.jce.symmetric.SymmetricCryptor;
import code.ponfee.commons.util.Base64UrlSafe;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public abstract class CryptoProvider {
    public abstract byte[] encrypt(@Nonnull byte[] var1);

    public abstract byte[] decrypt(@Nonnull byte[] var1);

    public byte[] sign(byte[] data) {
        throw new UnsupportedOperationException("cannot support signature.");
    }

    public boolean verify(byte[] data, byte[] signed) {
        throw new UnsupportedOperationException("cannot support verify signature.");
    }

    public final String encrypt(String plaintext) {
        return this.encrypt(plaintext, StandardCharsets.UTF_8);
    }

    public final String encrypt(String plaintext, Charset charset) {
        if (plaintext == null) {
            return null;
        }
        return Base64UrlSafe.encode(this.encrypt(plaintext.getBytes(charset)));
    }

    public final String decrypt(String ciphertext) {
        return this.decrypt(ciphertext, StandardCharsets.UTF_8);
    }

    public final String decrypt(String ciphertext, Charset charset) {
        if (ciphertext == null) {
            return null;
        }
        return new String(this.decrypt(Base64UrlSafe.decode(ciphertext)), charset);
    }

    public final String sign(String data) {
        return this.sign(data, "UTF-8");
    }

    public final String sign(String data, String charset) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return null;
        }
        return Base64UrlSafe.encode(this.sign(data.getBytes(Charset.forName(charset))));
    }

    public final boolean verify(String data, String signed) {
        return this.verify(data, "UTF-8", signed);
    }

    public final boolean verify(String data, String charset, String signed) {
        return this.verify(data.getBytes(Charset.forName(charset)), Base64UrlSafe.decode(signed));
    }

    public static CryptoProvider symmetricKeyProvider(final SymmetricCryptor symmetricKey) {
        return new CryptoProvider(){

            @Override
            public byte[] encrypt(byte[] original) {
                return symmetricKey.encrypt(Objects.requireNonNull(original));
            }

            @Override
            public byte[] decrypt(byte[] encrypted) {
                return symmetricKey.decrypt(encrypted);
            }
        };
    }

    public static CryptoProvider rsaPublicKeyProvider(final String pkcs8PublicKey) {
        return new CryptoProvider(){
            final RSAPublicKey pubKey;
            {
                this.pubKey = RSAPublicKeys.fromPkcs8(pkcs8PublicKey);
            }

            @Override
            public byte[] encrypt(byte[] original) {
                return RSACryptor.encrypt(original, this.pubKey);
            }

            @Override
            public byte[] decrypt(byte[] encrypted) {
                throw new UnsupportedOperationException("cannot support decrypt.");
            }

            @Override
            public boolean verify(byte[] data, byte[] signed) {
                return RSACryptor.verifySha1(data, this.pubKey, signed);
            }
        };
    }

    public static CryptoProvider rsaPrivateKeyProvider(String pkcs8PrivateKey) {
        RSAPrivateKey priKey = RSAPrivateKeys.fromPkcs8(pkcs8PrivateKey);
        return CryptoProvider.rsaProvider(priKey, RSAPrivateKeys.extractPublicKey(priKey));
    }

    public static CryptoProvider rsaProvider(final RSAPrivateKey priKey, final RSAPublicKey pubKey) {
        return new CryptoProvider(){

            @Override
            public byte[] encrypt(byte[] original) {
                return RSACryptor.encrypt(original, pubKey);
            }

            @Override
            public byte[] decrypt(byte[] encrypted) {
                return RSACryptor.decrypt(encrypted, priKey);
            }

            @Override
            public byte[] sign(byte[] data) {
                return RSACryptor.signSha1(data, priKey);
            }

            @Override
            public boolean verify(byte[] data, byte[] signed) {
                return RSACryptor.verifySha1(data, pubKey, signed);
            }
        };
    }

    public static CryptoProvider sm2PublicKeyProvider(byte[] publicKey) {
        return CryptoProvider.sm2PublicKeyProvider(ECParameters.SM2_BEST, publicKey);
    }

    public static CryptoProvider sm2PublicKeyProvider(final ECParameters ecParameter, final byte[] publicKey) {
        return new CryptoProvider(){
            final byte[] publicKey0;
            {
                this.publicKey0 = Arrays.copyOf(publicKey, publicKey.length);
            }

            @Override
            public byte[] encrypt(byte[] original) {
                return SM2.encrypt(ecParameter, this.publicKey0, original);
            }

            @Override
            public byte[] decrypt(byte[] encrypted) {
                throw new UnsupportedOperationException("cannot support decrypt.");
            }

            @Override
            public boolean verify(byte[] data, byte[] signed) {
                return SM2.verify(ecParameter, data, signed, this.publicKey0);
            }
        };
    }

    public static CryptoProvider sm2PrivateKeyProvider(byte[] publicKey, byte[] privateKey) {
        return CryptoProvider.sm2PrivateKeyProvider(ECParameters.SM2_BEST, publicKey, privateKey);
    }

    public static CryptoProvider sm2PrivateKeyProvider(final ECParameters ecParameter, final byte[] publicKey, final byte[] privateKey) {
        return new CryptoProvider(){
            final byte[] publicKey0;
            final byte[] privateKey0;
            {
                this.publicKey0 = Arrays.copyOf(publicKey, publicKey.length);
                this.privateKey0 = Arrays.copyOf(privateKey, privateKey.length);
            }

            @Override
            public byte[] encrypt(byte[] original) {
                return SM2.encrypt(ecParameter, this.publicKey0, original);
            }

            @Override
            public byte[] decrypt(byte[] encrypted) {
                return SM2.decrypt(ecParameter, this.privateKey0, encrypted);
            }

            @Override
            public byte[] sign(byte[] data) {
                return SM2.sign(ecParameter, data, this.publicKey0, this.privateKey0);
            }

            @Override
            public boolean verify(byte[] data, byte[] signed) {
                return SM2.verify(ecParameter, data, signed, this.publicKey0);
            }
        };
    }

    public static CryptoProvider ecdsaPublicKeyProvider(final byte[] publicKey) {
        return new CryptoProvider(){
            final ECPublicKey publicKey0;
            {
                this.publicKey0 = ECDSASigner.decodePublicKey(publicKey);
            }

            @Override
            public byte[] encrypt(byte[] original) {
                throw new UnsupportedOperationException("ECDSA cannot support encrypt.");
            }

            @Override
            public byte[] decrypt(byte[] encrypted) {
                throw new UnsupportedOperationException("ECDSA cannot support decrypt.");
            }

            @Override
            public boolean verify(byte[] data, byte[] signed) {
                return ECDSASigner.verifySha256(data, signed, this.publicKey0);
            }
        };
    }

    public static CryptoProvider ecdsaPrivateKeyProvider(final byte[] publicKey, final byte[] privateKey) {
        return new CryptoProvider(){
            final ECPublicKey publicKey0;
            final ECPrivateKey privateKey0;
            {
                this.publicKey0 = ECDSASigner.decodePublicKey(publicKey);
                this.privateKey0 = ECDSASigner.decodePrivateKey(privateKey);
            }

            @Override
            public byte[] encrypt(byte[] original) {
                throw new UnsupportedOperationException("ECDSA cannot support encrypt.");
            }

            @Override
            public byte[] decrypt(byte[] encrypted) {
                throw new UnsupportedOperationException("ECDSA cannot support decrypt.");
            }

            @Override
            public byte[] sign(byte[] data) {
                return ECDSASigner.signSha256(data, this.privateKey0);
            }

            @Override
            public boolean verify(byte[] data, byte[] signed) {
                return ECDSASigner.verifySha256(data, signed, this.publicKey0);
            }
        };
    }
}

