/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.jce.digest;

import code.ponfee.commons.jce.HmacAlgorithms;
import code.ponfee.commons.jce.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;

public final class HmacUtils {
    private static final int BUFF_SIZE = 4096;

    public static byte[] sha1(byte[] key, byte[] data) {
        return HmacUtils.crypt(key, data, HmacAlgorithms.HmacSHA1);
    }

    public static byte[] sha1(byte[] key, InputStream data) {
        return HmacUtils.crypt(key, data, HmacAlgorithms.HmacSHA1);
    }

    public static String sha1Hex(byte[] key, byte[] data) {
        return Hex.encodeHexString((byte[])HmacUtils.sha1(key, data));
    }

    public static String sha1Hex(byte[] key, InputStream data) {
        return Hex.encodeHexString((byte[])HmacUtils.sha1(key, data));
    }

    public static byte[] md5(byte[] key, byte[] data) {
        return HmacUtils.crypt(key, data, HmacAlgorithms.HmacMD5);
    }

    public static String md5Hex(byte[] key, byte[] data) {
        return Hex.encodeHexString((byte[])HmacUtils.md5(key, data));
    }

    public static byte[] sha224(byte[] key, byte[] data) {
        return HmacUtils.crypt(key, data, HmacAlgorithms.HmacSHA224);
    }

    public static String sha224Hex(byte[] key, byte[] data) {
        return Hex.encodeHexString((byte[])HmacUtils.sha224(key, data));
    }

    public static byte[] sha256(byte[] key, byte[] data) {
        return HmacUtils.crypt(key, data, HmacAlgorithms.HmacSHA256);
    }

    public static String sha256Hex(byte[] key, byte[] data) {
        return Hex.encodeHexString((byte[])HmacUtils.sha256(key, data));
    }

    public static byte[] sha384(byte[] key, byte[] data) {
        return HmacUtils.crypt(key, data, HmacAlgorithms.HmacSHA384);
    }

    public static String sha384Hex(byte[] key, byte[] data) {
        return Hex.encodeHexString((byte[])HmacUtils.sha384(key, data));
    }

    public static byte[] sha512(byte[] key, byte[] data) {
        return HmacUtils.crypt(key, data, HmacAlgorithms.HmacSHA512);
    }

    public static String sha512Hex(byte[] key, byte[] data) {
        return Hex.encodeHexString((byte[])HmacUtils.sha512(key, data));
    }

    public static byte[] ripeMD128(byte[] key, byte[] data) {
        return HmacUtils.crypt(key, data, HmacAlgorithms.HmacRipeMD128, Providers.BC);
    }

    public static String ripeMD128Hex(byte[] key, byte[] data) {
        return Hex.encodeHexString((byte[])HmacUtils.ripeMD128(key, data));
    }

    public static byte[] ripeMD160(byte[] key, byte[] data) {
        return HmacUtils.crypt(key, data, HmacAlgorithms.HmacRipeMD160, Providers.BC);
    }

    public static String ripeMD160Hex(byte[] key, byte[] data) {
        return Hex.encodeHexString((byte[])HmacUtils.ripeMD160(key, data));
    }

    public static byte[] ripeMD256(byte[] key, byte[] data) {
        return HmacUtils.crypt(key, data, HmacAlgorithms.HmacRipeMD256, Providers.BC);
    }

    public static String ripeMD256Hex(byte[] key, byte[] data) {
        return Hex.encodeHexString((byte[])HmacUtils.ripeMD256(key, data));
    }

    public static byte[] ripeMD320(byte[] key, byte[] data) {
        return HmacUtils.crypt(key, data, HmacAlgorithms.HmacRipeMD320, Providers.BC);
    }

    public static String ripeMD320Hex(byte[] key, byte[] data) {
        return Hex.encodeHexString((byte[])HmacUtils.ripeMD320(key, data));
    }

    public static Mac getInitializedMac(HmacAlgorithms algorithm, byte[] key) {
        return HmacUtils.getInitializedMac(algorithm, null, key);
    }

    public static Mac getInitializedMac(HmacAlgorithms algorithm, Provider provider, byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException("Null key");
        }
        try {
            Mac mac = provider == null ? Mac.getInstance(algorithm.algorithm()) : Mac.getInstance(algorithm.algorithm(), provider);
            mac.init(new SecretKeySpec(key, mac.getAlgorithm()));
            return mac;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("unknown algorithm: " + (Object)((Object)algorithm), e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("invalid key: " + Hex.encodeHexString((byte[])key), e);
        }
    }

    public static byte[] crypt(byte[] key, byte[] data, HmacAlgorithms alg) {
        return HmacUtils.crypt(key, data, alg, null);
    }

    public static byte[] crypt(byte[] key, byte[] data, HmacAlgorithms alg, Provider provider) {
        return HmacUtils.getInitializedMac(alg, provider, key).doFinal(data);
    }

    public static byte[] crypt(byte[] key, InputStream input, HmacAlgorithms alg) {
        return HmacUtils.crypt(key, input, alg, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] crypt(byte[] key, InputStream input, HmacAlgorithms alg, Provider provider) {
        try (InputStream in = input;){
            int n;
            Mac mac = HmacUtils.getInitializedMac(alg, provider, key);
            byte[] buffer = new byte[4096];
            while ((n = in.read(buffer, 0, 4096)) != -1) {
                mac.update(buffer, 0, n);
            }
            byte[] byArray = mac.doFinal();
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("read data error:" + e);
        }
    }
}

