/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.jce.implementation.ecc;

import code.ponfee.commons.jce.implementation.Key;
import code.ponfee.commons.jce.implementation.ecc.ECPoint;
import code.ponfee.commons.jce.implementation.ecc.EllipticCurve;
import code.ponfee.commons.util.SecureRandoms;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class ECKey
implements Key {
    protected boolean secret;
    protected BigInteger dk;
    protected ECPoint beta;
    protected final EllipticCurve curve;

    public ECKey(EllipticCurve ec) {
        this.curve = ec;
        this.secret = true;
        this.dk = this.curve.getN() != null ? SecureRandoms.random(this.curve.getN()) : SecureRandoms.random(ec.getP().bitLength() + 17);
        this.beta = this.curve.getBasePointG().multiply(this.dk);
        this.beta.fastCache();
    }

    public String toString() {
        String str = "";
        if (this.secret) {
            str = "Private key: " + this.dk + ", ";
        }
        return str + "Public key: " + this.beta + ", Curve: " + this.curve;
    }

    @Override
    public boolean isPublic() {
        return !this.secret;
    }

    @Override
    public void writeKey(OutputStream out) throws IOException {
        DataOutputStream output = new DataOutputStream(out);
        this.curve.writeCurve(output);
        output.writeBoolean(this.secret);
        if (this.secret) {
            byte[] dk0 = this.dk.toByteArray();
            output.writeInt(dk0.length);
            output.write(dk0);
        }
        byte[] beta0 = this.beta.compress();
        output.writeInt(beta0.length);
        output.write(beta0);
    }

    @Override
    public Key readKey(InputStream in) throws IOException {
        DataInputStream input = new DataInputStream(in);
        ECKey key = new ECKey(new EllipticCurve(input));
        key.secret = input.readBoolean();
        if (key.secret) {
            byte[] dk0 = new byte[input.readInt()];
            input.read(dk0);
            key.dk = new BigInteger(1, dk0);
        }
        byte[] beta0 = new byte[input.readInt()];
        input.read(beta0);
        key.beta = new ECPoint(beta0, key.curve);
        return key;
    }

    @Override
    public Key getPublic() {
        if (!this.secret) {
            return this;
        }
        ECKey pubKey = new ECKey(this.curve);
        pubKey.beta = this.beta;
        pubKey.dk = BigInteger.ZERO;
        pubKey.secret = false;
        return pubKey;
    }
}

