/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.jce.implementation.rsa;

import code.ponfee.commons.jce.implementation.Cryptor;
import code.ponfee.commons.jce.implementation.Key;
import code.ponfee.commons.jce.implementation.rsa.RSAKey;
import code.ponfee.commons.util.SecureRandoms;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Arrays;

public abstract class AbstractRSACryptor
extends Cryptor {
    private final boolean isPadding;

    public AbstractRSACryptor(boolean isPadding) {
        this.isPadding = isPadding;
    }

    public int getOriginBlockSize(RSAKey rsaKey) {
        return rsaKey.n.bitLength() / 8 - 1;
    }

    public int getCipherBlockSize(RSAKey rsaKey) {
        return rsaKey.n.bitLength() / 8;
    }

    @Override
    public byte[] encrypt(byte[] input, int length, Key ek) {
        RSAKey rsaKey = (RSAKey)ek;
        BigInteger exponent = this.getExponent(rsaKey);
        int originBlockSize = this.getOriginBlockSize(rsaKey);
        int cipherBlockSize = this.getCipherBlockSize(rsaKey);
        ByteArrayOutputStream out = new ByteArrayOutputStream(input.length);
        try {
            int len = input.length;
            for (int offset = 0; offset < len; offset += originBlockSize) {
                int to = Math.min(len, offset + originBlockSize);
                byte[] origin = this.isPadding ? AbstractRSACryptor.encodeBlock(input, offset, to, cipherBlockSize, rsaKey) : Arrays.copyOfRange(input, offset, to);
                byte[] encrypted = new BigInteger(1, origin).modPow(exponent, rsaKey.n).toByteArray();
                AbstractRSACryptor.fixedByteArray(encrypted, cipherBlockSize, out);
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new SecurityException(e);
        }
    }

    @Override
    public byte[] decrypt(byte[] input, Key dk) {
        RSAKey rsaKey = (RSAKey)dk;
        BigInteger exponent = this.getExponent(rsaKey);
        int cipherBlockSize = this.getCipherBlockSize(rsaKey);
        int originBlockSize = this.getOriginBlockSize(rsaKey);
        ByteArrayOutputStream output = new ByteArrayOutputStream(input.length);
        try {
            int len = input.length;
            for (int offset = 0; offset < len; offset += cipherBlockSize) {
                byte[] encrypted = Arrays.copyOfRange(input, offset, Math.min(len, offset + cipherBlockSize));
                byte[] origin = new BigInteger(1, encrypted).modPow(exponent, rsaKey.n).toByteArray();
                if (this.isPadding) {
                    AbstractRSACryptor.decodeBlock(origin, cipherBlockSize, output);
                    continue;
                }
                if (offset + cipherBlockSize < len) {
                    AbstractRSACryptor.fixedByteArray(origin, originBlockSize, output);
                    continue;
                }
                AbstractRSACryptor.trimByteArray(origin, output);
            }
            return output.toByteArray();
        }
        catch (IOException e) {
            throw new SecurityException(e);
        }
    }

    public void encrypt(InputStream input, Key ek, OutputStream output) {
        RSAKey rsaKey = (RSAKey)ek;
        BigInteger exponent = this.getExponent(rsaKey);
        int cipherBlockSize = this.getCipherBlockSize(rsaKey);
        byte[] buffer = new byte[this.getOriginBlockSize(rsaKey)];
        try {
            int len;
            while ((len = input.read(buffer)) != -1) {
                byte[] origin = this.isPadding ? AbstractRSACryptor.encodeBlock(buffer, 0, len, cipherBlockSize, rsaKey) : Arrays.copyOfRange(buffer, 0, len);
                byte[] encrypted = new BigInteger(1, origin).modPow(exponent, rsaKey.n).toByteArray();
                AbstractRSACryptor.fixedByteArray(encrypted, cipherBlockSize, output);
            }
            output.flush();
        }
        catch (IOException e) {
            throw new SecurityException(e);
        }
    }

    public void decrypt(InputStream input, Key dk, OutputStream output) {
        RSAKey rsaKey = (RSAKey)dk;
        BigInteger exponent = this.getExponent(rsaKey);
        int cipherBlockSize = this.getCipherBlockSize(rsaKey);
        int originBlockSize = this.getOriginBlockSize(rsaKey);
        byte[] buffer = new byte[cipherBlockSize];
        try {
            int len;
            int offset = 0;
            int inputLen = input.available();
            while ((len = input.read(buffer)) != -1) {
                byte[] encrypted = Arrays.copyOfRange(buffer, 0, len);
                byte[] origin = new BigInteger(1, encrypted).modPow(exponent, rsaKey.n).toByteArray();
                if (this.isPadding) {
                    AbstractRSACryptor.decodeBlock(origin, cipherBlockSize, output);
                } else if (offset + cipherBlockSize < inputLen) {
                    AbstractRSACryptor.fixedByteArray(origin, originBlockSize, output);
                } else {
                    AbstractRSACryptor.trimByteArray(origin, output);
                }
                offset += cipherBlockSize;
            }
            output.flush();
        }
        catch (IOException e) {
            throw new SecurityException(e);
        }
    }

    public final BigInteger getExponent(RSAKey rsaKey) {
        return rsaKey.secret ? rsaKey.d : rsaKey.e;
    }

    @Override
    public final Key generateKey() {
        return this.generateKey(2048);
    }

    public final Key generateKey(int keySize) {
        return new RSAKey(keySize);
    }

    public final String toString() {
        return this.getClass().getSimpleName();
    }

    private static void fixedByteArray(byte[] data, int fixedSize, OutputStream out) throws IOException {
        if (data.length < fixedSize) {
            int heading = fixedSize - data.length;
            for (int i = 0; i < heading; ++i) {
                out.write(0);
            }
            out.write(data, 0, data.length);
        } else {
            out.write(data, data.length - fixedSize, fixedSize);
        }
    }

    private static void trimByteArray(byte[] data, OutputStream out) throws IOException {
        int i;
        int len = data.length;
        for (i = 0; i < len && data[i] == 0; ++i) {
        }
        if (i < len) {
            out.write(data, i, len - i);
        }
    }

    private static byte[] encodeBlock(byte[] input, int from, int to, int cipherBlockSize, RSAKey rsaKey) {
        int length = to - from;
        if (length > cipherBlockSize) {
            throw new IllegalArgumentException("input data too large");
        }
        if (cipherBlockSize - length - 3 < 8) {
            throw new IllegalArgumentException("the padding too small");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(cipherBlockSize);
        baos.write(0);
        if (rsaKey.secret) {
            baos.write(1);
            int pLen = cipherBlockSize - length - 1;
            for (int i = 2; i < pLen; ++i) {
                baos.write(255);
            }
        } else {
            baos.write(2);
            int pLen = cipherBlockSize - length - 1;
            for (int i = 2; i < pLen; ++i) {
                byte b;
                while ((b = (byte)SecureRandoms.nextInt()) == 0) {
                }
                baos.write(b);
            }
        }
        baos.write(0);
        baos.write(input, from, length);
        return baos.toByteArray();
    }

    private static void decodeBlock(byte[] input, int cipherBlockSize, OutputStream out) throws IOException {
        byte pad;
        int start;
        int removedZeroLen = input[0] == 0 ? 0 : 1;
        if (input.length != cipherBlockSize - removedZeroLen) {
            throw new IllegalArgumentException("block incorrect size");
        }
        byte type = input[1 - removedZeroLen];
        if (type != 1 && type != 2) {
            throw new IllegalArgumentException("unknown block type");
        }
        for (start = 2 - removedZeroLen; start != input.length && (pad = input[start]) != 0; ++start) {
            if (type != 1 || pad == -1) continue;
            throw new IllegalArgumentException("invalid block padding");
        }
        if (++start > input.length || start < 11 - removedZeroLen) {
            throw new IllegalArgumentException("invalid block data");
        }
        out.write(input, start, input.length - start);
    }
}

