/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.jce.implementation.rsa;

import code.ponfee.commons.jce.implementation.Key;
import code.ponfee.commons.util.SecureRandoms;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.apache.commons.io.IOUtils;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class RSAKey
implements Key {
    private static final SecureRandom SECURE_RANDOM = new SecureRandom(SecureRandoms.generateSeed(24));
    public static final int RSA_F4 = 65537;
    public final BigInteger n;
    public final BigInteger e;
    public final BigInteger d;
    public final BigInteger p;
    public final BigInteger q;
    public final BigInteger pe;
    public final BigInteger qe;
    public final BigInteger coeff;
    public final boolean secret;

    public RSAKey(int keySize) {
        this(keySize, 65537);
    }

    public RSAKey(int keySize, int e) {
        this.secret = true;
        KeyPair pair = RSAKey.generateKey(keySize, e);
        this.e = pair.e;
        this.p = pair.p;
        this.q = pair.q;
        this.n = pair.n;
        this.pe = pair.pe;
        this.qe = pair.qe;
        this.d = pair.d;
        this.coeff = pair.coeff;
    }

    public RSAKey(BigInteger n, BigInteger e, BigInteger d, BigInteger p, BigInteger q, BigInteger pe, BigInteger qe, BigInteger coeff) {
        Preconditions.checkArgument((n != null && e != null && d != null && p != null && q != null && pe != null && qe != null && coeff != null ? 1 : 0) != 0);
        this.secret = true;
        this.n = n;
        this.e = e;
        this.d = d;
        this.p = p;
        this.q = q;
        this.pe = pe;
        this.qe = qe;
        this.coeff = coeff;
    }

    public RSAKey(BigInteger n, BigInteger e) {
        Preconditions.checkArgument((n != null && e != null ? 1 : 0) != 0);
        this.secret = false;
        this.n = n;
        this.e = e;
        this.d = null;
        this.p = null;
        this.q = null;
        this.pe = null;
        this.qe = null;
        this.coeff = null;
    }

    @Override
    public boolean isPublic() {
        return !this.secret;
    }

    public boolean isSecret() {
        return this.secret;
    }

    @Override
    public RSAKey getPublic() {
        return new RSAKey(this.n, this.e);
    }

    @Override
    public void writeKey(OutputStream out) throws IOException {
        DerOutputStream der = new DerOutputStream();
        der.putInteger(this.secret ? 0 : 1);
        der.putInteger(this.n);
        der.putInteger(this.e);
        if (this.secret) {
            der.putInteger(this.d);
            der.putInteger(this.p);
            der.putInteger(this.q);
            der.putInteger(this.pe);
            der.putInteger(this.qe);
            der.putInteger(this.coeff);
        }
        DerValue dervalue = new DerValue(48, der.toByteArray());
        out.write(dervalue.toByteArray());
        der.close();
    }

    @Override
    public RSAKey readKey(InputStream in) throws IOException {
        RSAKey rsaKey;
        DerValue der = new DerInputStream(IOUtils.toByteArray((InputStream)in)).getDerValue();
        if (der.getTag() != 48) {
            throw new IOException("Not a SEQUENCE");
        }
        DerInputStream derIn = der.getData();
        boolean secret = der.getInteger() == 0;
        BigInteger n = RSAKey.getBigInteger(derIn);
        BigInteger e = RSAKey.getBigInteger(derIn);
        if (secret) {
            BigInteger d = RSAKey.getBigInteger(derIn);
            BigInteger p = RSAKey.getBigInteger(derIn);
            BigInteger q = RSAKey.getBigInteger(derIn);
            BigInteger pe = RSAKey.getBigInteger(derIn);
            BigInteger qe = RSAKey.getBigInteger(derIn);
            BigInteger coeff = RSAKey.getBigInteger(derIn);
            rsaKey = new RSAKey(n, e, d, p, q, pe, qe, coeff);
        } else {
            rsaKey = new RSAKey(n, e);
        }
        if (derIn.available() != 0) {
            throw new IOException("Extra data available");
        }
        return rsaKey;
    }

    private static BigInteger getBigInteger(DerInputStream derIn) {
        BigInteger biginteger;
        try {
            biginteger = derIn.getBigInteger();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        if (biginteger.signum() < 0) {
            biginteger = new BigInteger(1, biginteger.toByteArray());
        }
        return biginteger;
    }

    public static KeyPair generateKey(int keySize, int e) {
        KeyPair keyPair = new KeyPair();
        keyPair.e = BigInteger.valueOf(e);
        int i = keySize + 1 >> 1;
        int j = keySize - i;
        do {
            keyPair.p = BigInteger.probablePrime(i, RSAKey.SECURE_RANDOM);
            do {
                keyPair.q = BigInteger.probablePrime(j, RSAKey.SECURE_RANDOM);
                if (keyPair.p.compareTo(keyPair.q) < 0) {
                    BigInteger temp = keyPair.p;
                    keyPair.p = keyPair.q;
                    keyPair.q = temp;
                }
                keyPair.n = keyPair.p.multiply(keyPair.q);
            } while (keyPair.n.bitLength() != keySize);
            keyPair.p1 = keyPair.p.subtract(BigInteger.ONE);
            keyPair.q1 = keyPair.q.subtract(BigInteger.ONE);
            keyPair.phi = keyPair.p1.multiply(keyPair.q1);
        } while (!keyPair.e.gcd(keyPair.phi).equals(BigInteger.ONE));
        keyPair.d = keyPair.e.modInverse(keyPair.phi);
        keyPair.pe = keyPair.d.mod(keyPair.p1);
        keyPair.qe = keyPair.d.mod(keyPair.q1);
        keyPair.coeff = keyPair.q.modInverse(keyPair.p);
        return keyPair;
    }

    private static class KeyPair {
        private BigInteger n;
        private BigInteger e;
        private BigInteger d;
        private BigInteger p;
        private BigInteger q;
        private BigInteger pe;
        private BigInteger qe;
        private BigInteger coeff;
        private BigInteger p1;
        private BigInteger q1;
        private BigInteger phi;

        private KeyPair() {
        }
    }
}

