/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.jce.implementation.symmetric;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public class RC4 {
    private static final int STATE_LENGTH = 256;
    private final byte[] sBox = new byte[256];

    public RC4(byte[] keyBytes) {
        int i;
        for (i = 0; i < 256; ++i) {
            this.sBox[i] = (byte)i;
        }
        int j = 0;
        int k = 0;
        int keyLen = keyBytes.length;
        for (i = 0; i < 256; ++i) {
            j = j + this.sBox[i] + keyBytes[k++] & 0xFF;
            ArrayUtils.swap((byte[])this.sBox, (int)i, (int)j);
            if (k != keyLen) continue;
            k = 0;
        }
    }

    public byte encrypt(byte in) {
        byte[] sBox = Arrays.copyOf(this.sBox, this.sBox.length);
        int x = 1;
        int y = sBox[x] & 0xFF;
        ArrayUtils.swap((byte[])sBox, (int)x, (int)y);
        return (byte)(in ^ sBox[sBox[x] + sBox[y] & 0xFF]);
    }

    public byte decrypt(byte in) {
        return this.encrypt(in);
    }

    public byte[] encrypt(byte[] in) {
        byte[] out = new byte[in.length];
        this.doCrypt(in, 0, in.length, out, 0);
        return out;
    }

    public byte[] decrypt(byte[] in) {
        return this.encrypt(in);
    }

    private void doCrypt(byte[] in, int inOff, int len, byte[] out, int outOff) {
        byte[] sBox = Arrays.copyOf(this.sBox, this.sBox.length);
        int x = 0;
        int y = 0;
        for (int i = 0; i < len; ++i) {
            x = x + 1 & 0xFF;
            y = sBox[x] + y & 0xFF;
            ArrayUtils.swap((byte[])sBox, (int)x, (int)y);
            out[i + outOff] = (byte)(in[i + inOff] ^ sBox[sBox[x] + sBox[y] & 0xFF]);
        }
    }
}

