/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.jce.security;

import code.ponfee.commons.jce.Providers;
import code.ponfee.commons.jce.symmetric.Algorithm;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class ECDHKeyExchanger {
    private static final String ALGORITHM = "ECDH";

    public static Pair<ECPublicKey, ECPrivateKey> initPartAKey() {
        return ECDHKeyExchanger.initPartAKey(256);
    }

    public static Pair<ECPublicKey, ECPrivateKey> initPartAKey(int keySize) {
        KeyPairGenerator keyPairGenerator = Providers.getKeyPairGenerator(ALGORITHM);
        keyPairGenerator.initialize(keySize);
        KeyPair pair = keyPairGenerator.generateKeyPair();
        return ImmutablePair.of((Object)((ECPublicKey)pair.getPublic()), (Object)((ECPrivateKey)pair.getPrivate()));
    }

    public static Pair<ECPublicKey, ECPrivateKey> initPartBKey(byte[] partAPubKey) {
        return ECDHKeyExchanger.initPartBKey(ECDHKeyExchanger.decodePublicKey(partAPubKey));
    }

    public static Pair<ECPublicKey, ECPrivateKey> initPartBKey(ECPublicKey partAPublicKey) {
        KeyPairGenerator keyPairGen = Providers.getKeyPairGenerator(partAPublicKey.getAlgorithm());
        try {
            keyPairGen.initialize(partAPublicKey.getParams());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new SecurityException(e);
        }
        KeyPair keyPair = keyPairGen.generateKeyPair();
        return ImmutablePair.of((Object)((ECPublicKey)keyPair.getPublic()), (Object)((ECPrivateKey)keyPair.getPrivate()));
    }

    public static byte[] encode(ECPublicKey key) {
        return key.getEncoded();
    }

    public static byte[] encode(ECPrivateKey key) {
        return key.getEncoded();
    }

    public static ECPrivateKey decodePrivateKey(byte[] privateKey) {
        KeyFactory keyFactory = Providers.getKeyFactory(ALGORITHM);
        try {
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privateKey);
            return (ECPrivateKey)keyFactory.generatePrivate(pkcs8KeySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new SecurityException(e);
        }
    }

    public static ECPublicKey decodePublicKey(byte[] publicKey) {
        KeyFactory keyFactory = Providers.getKeyFactory(ALGORITHM);
        try {
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(publicKey);
            return (ECPublicKey)keyFactory.generatePublic(x509KeySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new SecurityException(e);
        }
    }

    public static SecretKey genSecretKey(byte[] bPriKey, byte[] aPubKey) {
        return ECDHKeyExchanger.genSecretKey(ECDHKeyExchanger.decodePrivateKey(bPriKey), ECDHKeyExchanger.decodePublicKey(aPubKey));
    }

    public static SecretKey genSecretKey(ECPrivateKey bPriKey, ECPublicKey aPubKey) {
        KeyAgreement keyAgree = Providers.getKeyAgreement(aPubKey.getAlgorithm());
        try {
            keyAgree.init(bPriKey);
            keyAgree.doPhase(aPubKey, true);
            return keyAgree.generateSecret(Algorithm.DESede.name());
        }
        catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new SecurityException(e);
        }
    }

    public static byte[] encrypt(byte[] data, SecretKey secretKey) {
        Cipher cipher = Providers.getCipher(secretKey.getAlgorithm());
        try {
            cipher.init(1, secretKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public static byte[] decrypt(byte[] data, SecretKey secretKey) {
        Cipher cipher = Providers.getCipher(secretKey.getAlgorithm());
        try {
            cipher.init(2, secretKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }
}

