/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.jce.security;

import code.ponfee.commons.jce.Providers;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class ECDSASigner {
    private static final String ALGORITHM = "EC";

    public static Pair<ECPublicKey, ECPrivateKey> generateKeyPair() {
        return ECDSASigner.generateKeyPair(256);
    }

    public static Pair<ECPublicKey, ECPrivateKey> generateKeyPair(int keySize) {
        KeyPairGenerator keyPairGen = Providers.getKeyPairGenerator(ALGORITHM);
        keyPairGen.initialize(keySize);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        return ImmutablePair.of((Object)((ECPublicKey)keyPair.getPublic()), (Object)((ECPrivateKey)keyPair.getPrivate()));
    }

    public static byte[] encode(ECPublicKey key) {
        return key.getEncoded();
    }

    public static byte[] encode(ECPrivateKey key) {
        return key.getEncoded();
    }

    public static ECPublicKey decodePublicKey(byte[] publicKey) {
        KeyFactory keyFactory = Providers.getKeyFactory(ALGORITHM);
        try {
            return (ECPublicKey)keyFactory.generatePublic(new X509EncodedKeySpec(publicKey));
        }
        catch (InvalidKeySpecException e) {
            throw new SecurityException(e);
        }
    }

    public static ECPrivateKey decodePrivateKey(byte[] privateKey) {
        KeyFactory keyFactory = Providers.getKeyFactory(ALGORITHM);
        try {
            return (ECPrivateKey)keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKey));
        }
        catch (InvalidKeySpecException e) {
            throw new SecurityException(e);
        }
    }

    public static byte[] signSha1(byte[] data, ECPrivateKey privateKey) {
        return ECDSASigner.sign(data, privateKey, ECDSASignAlgorithms.SHA1withECDSA);
    }

    public static boolean verifySha1(byte[] data, byte[] signed, ECPublicKey publicKey) {
        return ECDSASigner.verify(data, signed, publicKey, ECDSASignAlgorithms.SHA1withECDSA);
    }

    public static byte[] signSha256(byte[] data, ECPrivateKey privateKey) {
        return ECDSASigner.sign(data, privateKey, ECDSASignAlgorithms.SHA256withECDSA);
    }

    public static boolean verifySha256(byte[] data, byte[] signed, ECPublicKey publicKey) {
        return ECDSASigner.verify(data, signed, publicKey, ECDSASignAlgorithms.SHA256withECDSA);
    }

    public static byte[] signSha512(byte[] data, ECPrivateKey privateKey) {
        return ECDSASigner.sign(data, privateKey, ECDSASignAlgorithms.SHA512withECDSA);
    }

    public static boolean verifySha512(byte[] data, byte[] signed, ECPublicKey publicKey) {
        return ECDSASigner.verify(data, signed, publicKey, ECDSASignAlgorithms.SHA512withECDSA);
    }

    private static byte[] sign(byte[] data, ECPrivateKey privateKey, ECDSASignAlgorithms algorithm) {
        Signature signature = Providers.getSignature(algorithm.name());
        try {
            signature.initSign(privateKey);
            signature.update(data);
            return signature.sign();
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new SecurityException(e);
        }
    }

    private static boolean verify(byte[] data, byte[] signed, ECPublicKey publicKey, ECDSASignAlgorithms algorithm) {
        Signature signature = Providers.getSignature(algorithm.name());
        try {
            signature.initVerify(publicKey);
            signature.update(data);
            return signature.verify(signed);
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new SecurityException(e);
        }
    }

    public static enum ECDSASignAlgorithms {
        SHA1withECDSA,
        SHA256withECDSA,
        SHA384withECDSA,
        SHA512withECDSA;

    }
}

