/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.jce.security;

import code.ponfee.commons.io.Closeables;
import code.ponfee.commons.jce.Providers;
import code.ponfee.commons.jce.RSACipherPaddings;
import code.ponfee.commons.jce.RSASignAlgorithms;
import code.ponfee.commons.jce.security.RSAPrivateKeys;
import code.ponfee.commons.jce.security.RSAPublicKeys;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;

public final class RSACryptor {
    static final String ALG_RSA = "RSA";

    private RSACryptor() {
    }

    public static RSAKeyPair generateKeyPair() {
        return RSACryptor.generateKeyPair(1024);
    }

    public static RSAKeyPair generateKeyPair(int keySize) {
        KeyPairGenerator keyPairGen = Providers.getKeyPairGenerator(ALG_RSA);
        keyPairGen.initialize(keySize);
        KeyPair pair = keyPairGen.generateKeyPair();
        return new RSAKeyPair((RSAPrivateKey)pair.getPrivate(), (RSAPublicKey)pair.getPublic());
    }

    public static byte[] signMd5(byte[] data, RSAPrivateKey privateKey) {
        return RSACryptor.sign(data, privateKey, RSASignAlgorithms.MD5withRSA);
    }

    public static byte[] signSha1(byte[] data, RSAPrivateKey privateKey) {
        return RSACryptor.sign(data, privateKey, RSASignAlgorithms.SHA1withRSA);
    }

    public static byte[] signSha256(byte[] data, RSAPrivateKey privateKey) {
        return RSACryptor.sign(data, privateKey, RSASignAlgorithms.SHA256withRSA);
    }

    public static boolean verifyMd5(byte[] data, RSAPublicKey publicKey, byte[] signed) {
        return RSACryptor.verify(data, publicKey, signed, RSASignAlgorithms.MD5withRSA);
    }

    public static boolean verifySha1(byte[] data, RSAPublicKey publicKey, byte[] signed) {
        return RSACryptor.verify(data, publicKey, signed, RSASignAlgorithms.SHA1withRSA);
    }

    public static boolean verifySha256(byte[] data, RSAPublicKey publicKey, byte[] signed) {
        return RSACryptor.verify(data, publicKey, signed, RSASignAlgorithms.SHA256withRSA);
    }

    public static <T extends Key & RSAKey> byte[] encrypt(byte[] data, T key) {
        return RSACryptor.docrypt(data, key, 1, true);
    }

    public static <T extends Key & RSAKey> byte[] encryptNoPadding(byte[] data, T key) {
        return RSACryptor.docrypt(data, key, 1, false);
    }

    public static <T extends Key & RSAKey> void encrypt(InputStream input, T key, OutputStream out) {
        RSACryptor.docrypt(input, key, out, 1, true);
    }

    public static <T extends Key & RSAKey> void encryptNoPadding(InputStream input, T key, OutputStream out) {
        RSACryptor.docrypt(input, key, out, 1, false);
    }

    public static <T extends Key & RSAKey> byte[] decrypt(byte[] encrypted, T key) {
        return RSACryptor.docrypt(encrypted, key, 2, true);
    }

    public static <T extends Key & RSAKey> byte[] decryptNoPadding(byte[] encrypted, T key) {
        return RSACryptor.docrypt(encrypted, key, 2, false);
    }

    public static <T extends Key & RSAKey> void decrypt(InputStream input, T key, OutputStream out) {
        RSACryptor.docrypt(input, key, out, 2, true);
    }

    public static <T extends Key & RSAKey> void decryptNoPadding(InputStream input, T key, OutputStream out) {
        RSACryptor.docrypt(input, key, out, 2, false);
    }

    private static <T extends Key & RSAKey> int getBlockSize(int cryptMode, T key) {
        return cryptMode == 1 ? ((RSAKey)key).getModulus().bitLength() / 8 - 11 : ((RSAKey)key).getModulus().bitLength() / 8;
    }

    private static <T extends Key & RSAKey> void docrypt(InputStream input, T key, OutputStream out, int cryptMode, boolean isPadding) {
        Cipher cipher = Providers.getCipher(key.getAlgorithm() + (isPadding ? RSACipherPaddings.ECB_PKCS1PADDING.transform() : RSACipherPaddings.NONE_NOPADDING.transform()));
        try {
            int len;
            cipher.init(cryptMode, key);
            byte[] buffer = new byte[RSACryptor.getBlockSize(cryptMode, key)];
            while ((len = input.read(buffer)) != -1) {
                out.write(cipher.doFinal(buffer, 0, len));
            }
            out.flush();
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
        finally {
            Closeables.console(input);
        }
    }

    private static <T extends Key & RSAKey> byte[] docrypt(byte[] data, T key, int cryptMode, boolean isPadding) {
        int blockSize = RSACryptor.getBlockSize(cryptMode, key);
        Cipher cipher = Providers.getCipher(key.getAlgorithm() + (isPadding ? RSACipherPaddings.ECB_PKCS1PADDING.transform() : RSACipherPaddings.NONE_NOPADDING.transform()));
        try {
            cipher.init(cryptMode, key);
            ByteArrayOutputStream out = new ByteArrayOutputStream(data.length);
            int len = data.length;
            for (int offSet = 0; offSet < len; offSet += blockSize) {
                byte[] block = cipher.doFinal(data, offSet, Math.min(blockSize, len - offSet));
                out.write(block, 0, block.length);
            }
            out.flush();
            return out.toByteArray();
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    private static byte[] sign(byte[] data, RSAPrivateKey privateKey, RSASignAlgorithms alg) {
        Signature signature = Providers.getSignature(alg.name());
        try {
            signature.initSign(privateKey);
            signature.update(data);
            return signature.sign();
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new SecurityException(e);
        }
    }

    private static boolean verify(byte[] data, RSAPublicKey publicKey, byte[] signed, RSASignAlgorithms alg) {
        Signature signature = Providers.getSignature(alg.name());
        try {
            signature.initVerify(publicKey);
            signature.update(data);
            return signature.verify(signed);
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new SecurityException(e);
        }
    }

    public static final class RSAKeyPair
    implements Serializable {
        private static final long serialVersionUID = -1592700389671199076L;
        private final RSAPrivateKey privateKey;
        private final RSAPublicKey publicKey;

        private RSAKeyPair(RSAPrivateKey privateKey, RSAPublicKey publicKey) {
            this.privateKey = privateKey;
            this.publicKey = publicKey;
        }

        public RSAPrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public RSAPublicKey getPublicKey() {
            return this.publicKey;
        }

        public String toPkcs8PrivateKey() {
            return RSAPrivateKeys.toPkcs8(this.privateKey);
        }

        public String toPkcs1PrivateKey() {
            return RSAPrivateKeys.toPkcs1(this.privateKey);
        }

        public String toPkcs8PublicKey() {
            return RSAPublicKeys.toPkcs8(this.publicKey);
        }

        public String toPkcs1PublicKey() {
            return RSAPublicKeys.toPkcs1(this.publicKey);
        }
    }
}

