/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.jce.sm;

import java.util.Arrays;

public class SM3Digest {
    private static final int DIGEST_SIZE = 32;
    private static final int BLOCK_SIZE = 64;
    private static final int BUFFER_LENGTH = 64;
    private final byte[] xBuf = new byte[64];
    private final byte[] iv = new byte[SM3.IV.length];
    private int xBufOffset;
    private int cntBlock;

    private SM3Digest() {
        this.reset();
    }

    private SM3Digest(SM3Digest t) {
        System.arraycopy(t.xBuf, 0, this.xBuf, 0, t.xBuf.length);
        System.arraycopy(t.iv, 0, this.iv, 0, t.iv.length);
        this.xBufOffset = t.xBufOffset;
        this.cntBlock = t.cntBlock;
    }

    public static SM3Digest getInstance() {
        return new SM3Digest();
    }

    public static SM3Digest getInstance(SM3Digest t) {
        return new SM3Digest(t);
    }

    public void update(byte[] in) {
        this.update(in, 0, in.length);
    }

    public void update(byte[] input, int inputOffset, int len) {
        int partLen = 64 - this.xBufOffset;
        int dPos = inputOffset;
        if (partLen < len) {
            System.arraycopy(input, dPos, this.xBuf, this.xBufOffset, partLen);
            len -= partLen;
            dPos += partLen;
            this.doUpdate();
            while (len > 64) {
                System.arraycopy(input, dPos, this.xBuf, 0, 64);
                len -= 64;
                dPos += 64;
                this.doUpdate();
            }
        }
        System.arraycopy(input, dPos, this.xBuf, this.xBufOffset, len);
        this.xBufOffset += len;
    }

    public void update(byte in) {
        this.update(new byte[]{in}, 0, 1);
    }

    public void doFinal(byte[] out, int outOffset) {
        byte[] tmp = this.doFinal();
        System.arraycopy(tmp, 0, out, outOffset, tmp.length);
    }

    public byte[] doFinal(byte[] in) {
        this.update(in, 0, in.length);
        return this.doFinal();
    }

    public byte[] doFinal() {
        byte[] B = new byte[64];
        byte[] buffer = new byte[this.xBufOffset];
        System.arraycopy(this.xBuf, 0, buffer, 0, buffer.length);
        byte[] tmp = SM3.padding(buffer, this.cntBlock);
        for (int i = 0; i < tmp.length; i += 64) {
            System.arraycopy(tmp, i, B, 0, B.length);
            this.doHash(B);
        }
        byte[] v = Arrays.copyOf(this.iv, this.iv.length);
        this.reset();
        return v;
    }

    public void reset() {
        this.xBufOffset = 0;
        this.cntBlock = 0;
        System.arraycopy(SM3.IV, 0, this.iv, 0, SM3.IV.length);
    }

    public static int getDigestSize() {
        return 32;
    }

    private void doUpdate() {
        byte[] B = new byte[64];
        for (int i = 0; i < 64; i += 64) {
            System.arraycopy(this.xBuf, i, B, 0, B.length);
            this.doHash(B);
        }
        this.xBufOffset = 0;
    }

    private void doHash(byte[] B) {
        byte[] tmp = SM3.cf(this.iv, B);
        System.arraycopy(tmp, 0, this.iv, 0, this.iv.length);
        ++this.cntBlock;
    }

    private static class SM3 {
        static final byte[] IV;
        static final int[] T_J;

        private SM3() {
        }

        static byte[] cf(byte[] V, byte[] B) {
            return SM3.convert(SM3.cf(SM3.convert(V), SM3.convert(B)));
        }

        static byte[] padding(byte[] in, int bLen) {
            int k = 448 - ((in.length << 3) + 1 & 0x1FF);
            if (k < 0) {
                k = 960 - ((in.length << 3) + 1 & 0x1FF);
            }
            byte[] padd = new byte[++k / 8];
            padd[0] = -128;
            long n = (in.length << 3) + (bLen << 9);
            byte[] out = new byte[in.length + k / 8 + 8];
            int pos = 0;
            System.arraycopy(in, 0, out, 0, in.length);
            System.arraycopy(padd, 0, out, pos += in.length, padd.length);
            byte[] tmp = SM3.back(SM3.longToByteArray(n));
            System.arraycopy(tmp, 0, out, pos += padd.length, tmp.length);
            return out;
        }

        static int[] convert(byte[] arr) {
            int[] out = new int[arr.length >>> 2];
            byte[] tmp = new byte[4];
            for (int i = 0; i < arr.length; i += 4) {
                System.arraycopy(arr, i, tmp, 0, 4);
                out[i >>> 2] = SM3.bigEndianByteToInt(tmp);
            }
            return out;
        }

        static byte[] convert(int[] arr) {
            byte[] out = new byte[arr.length << 2];
            for (int i = 0; i < arr.length; ++i) {
                byte[] tmp = SM3.bigEndianIntToByte(arr[i]);
                System.arraycopy(tmp, 0, out, i << 2, 4);
            }
            return out;
        }

        static int[] cf(int[] V, int[] B) {
            int a = V[0];
            int b = V[1];
            int c = V[2];
            int d = V[3];
            int e = V[4];
            int f = V[5];
            int g = V[6];
            int h = V[7];
            int[][] arr = SM3.expand(B);
            int[] w = arr[0];
            int[] w1 = arr[1];
            for (int j = 0; j < 64; ++j) {
                int ss1 = SM3.bitCycleLeft(a, 12) + e + SM3.bitCycleLeft(T_J[j], j);
                ss1 = SM3.bitCycleLeft(ss1, 7);
                int ss2 = ss1 ^ SM3.bitCycleLeft(a, 12);
                int tt1 = SM3.FFj(a, b, c, j) + d + ss2 + w1[j];
                int tt2 = SM3.GGj(e, f, g, j) + h + ss1 + w[j];
                d = c;
                c = SM3.bitCycleLeft(b, 9);
                b = a;
                a = tt1;
                h = g;
                g = SM3.bitCycleLeft(f, 19);
                f = e;
                e = SM3.P0(tt2);
            }
            int[] out = new int[]{a ^ V[0], b ^ V[1], c ^ V[2], d ^ V[3], e ^ V[4], f ^ V[5], g ^ V[6], h ^ V[7]};
            return out;
        }

        static int[][] expand(int[] B) {
            int i;
            int[] W = new int[68];
            int[] W1 = new int[64];
            System.arraycopy(B, 0, W, 0, B.length);
            for (i = 16; i < 68; ++i) {
                W[i] = SM3.P1(W[i - 16] ^ W[i - 9] ^ SM3.bitCycleLeft(W[i - 3], 15)) ^ SM3.bitCycleLeft(W[i - 13], 7) ^ W[i - 6];
            }
            for (i = 0; i < 64; ++i) {
                W1[i] = W[i] ^ W[i + 4];
            }
            return new int[][]{W, W1};
        }

        static byte[] bigEndianIntToByte(int num) {
            return SM3.back(SM3.intToByteArray(num));
        }

        static int bigEndianByteToInt(byte[] bytes) {
            return SM3.byteArrayToInt(SM3.back(bytes));
        }

        static int FFj(int X, int Y, int Z, int j) {
            if (j >= 0 && j <= 15) {
                return SM3.FF1j(X, Y, Z);
            }
            return SM3.FF2j(X, Y, Z);
        }

        static int GGj(int X, int Y, int Z, int j) {
            if (j >= 0 && j <= 15) {
                return SM3.GG1j(X, Y, Z);
            }
            return SM3.GG2j(X, Y, Z);
        }

        static int FF1j(int X, int Y, int Z) {
            return X ^ Y ^ Z;
        }

        static int FF2j(int X, int Y, int Z) {
            return X & Y | X & Z | Y & Z;
        }

        static int GG1j(int X, int Y, int Z) {
            return X ^ Y ^ Z;
        }

        static int GG2j(int X, int Y, int Z) {
            return X & Y | ~X & Z;
        }

        static int P0(int X) {
            return X ^ SM3.bitCycleLeft(X, 9) ^ SM3.bitCycleLeft(X, 17);
        }

        static int P1(int X) {
            return X ^ SM3.bitCycleLeft(X, 15) ^ SM3.bitCycleLeft(X, 23);
        }

        static byte[] back(byte[] in) {
            byte[] out = new byte[in.length];
            for (int i = 0; i < out.length; ++i) {
                out[i] = in[out.length - i - 1];
            }
            return out;
        }

        static int bitCycleLeft(int n, int bitLen) {
            byte[] tmp = SM3.bigEndianIntToByte(n);
            int byteLen = (bitLen &= 0x1F) / 8;
            int len = bitLen & 7;
            if (byteLen > 0) {
                tmp = SM3.byteCycleLeft(tmp, byteLen);
            }
            if (len > 0) {
                tmp = SM3.bitSmall8CycleLeft(tmp, len);
            }
            return SM3.bigEndianByteToInt(tmp);
        }

        static byte[] bitSmall8CycleLeft(byte[] in, int len) {
            byte[] tmp = new byte[in.length];
            for (int i = 0; i < tmp.length; ++i) {
                byte t1 = (byte)((in[i] & 0xFF) << len);
                byte t2 = (byte)((in[(i + 1) % tmp.length] & 0xFF) >> 8 - len);
                byte t3 = (byte)(t1 | t2);
                tmp[i] = t3;
            }
            return tmp;
        }

        static byte[] byteCycleLeft(byte[] in, int byteLen) {
            byte[] tmp = new byte[in.length];
            System.arraycopy(in, byteLen, tmp, 0, in.length - byteLen);
            System.arraycopy(in, 0, tmp, in.length - byteLen, byteLen);
            return tmp;
        }

        static byte[] intToByteArray(int num) {
            return new byte[]{(byte)num, (byte)(num >>> 8), (byte)(num >>> 16), (byte)(num >>> 24)};
        }

        static int byteArrayToInt(byte[] bytes) {
            return bytes[3] << 24 | (bytes[2] & 0xFF) << 16 | (bytes[1] & 0xFF) << 8 | bytes[0] & 0xFF;
        }

        static byte[] longToByteArray(long value) {
            return new byte[]{(byte)value, (byte)(value >>> 8), (byte)(value >>> 16), (byte)(value >>> 24), (byte)(value >>> 32), (byte)(value >>> 40), (byte)(value >>> 48), (byte)(value >>> 56)};
        }

        static {
            int i;
            IV = new byte[]{115, -128, 22, 111, 73, 20, -78, -71, 23, 36, 66, -41, -38, -118, 6, 0, -87, 111, 48, -68, 22, 49, 56, -86, -29, -115, -18, 77, -80, -5, 14, 78};
            T_J = new int[64];
            for (i = 0; i < 16; ++i) {
                SM3.T_J[i] = 2043430169;
            }
            for (i = 16; i < 64; ++i) {
                SM3.T_J[i] = 2055708042;
            }
        }
    }
}

