/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.jce.symmetric;

import code.ponfee.commons.jce.Providers;
import code.ponfee.commons.jce.symmetric.Mode;
import code.ponfee.commons.jce.symmetric.PBECryptor;
import code.ponfee.commons.jce.symmetric.Padding;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.text.RandomStringGenerator;

public class PBECryptorBuilder {
    private static final RandomStringGenerator GENERATOR = new RandomStringGenerator.Builder().withinRange(33, 126).build();
    private final SecretKey secretKey;
    private final Provider provider;
    private Mode mode;
    private Padding padding;
    private AlgorithmParameterSpec parameter;

    private PBECryptorBuilder(PBECryptor.PBEAlgorithm algorithm, char[] pass, Provider provider) {
        try {
            SecretKeyFactory factory = Providers.getSecretKeyFactory(algorithm.name(), provider);
            this.secretKey = factory.generateSecret(new PBEKeySpec(pass));
            this.provider = provider;
        }
        catch (InvalidKeySpecException e) {
            throw new SecurityException(e);
        }
    }

    public static PBECryptorBuilder newBuilder(PBECryptor.PBEAlgorithm algorithm) {
        return PBECryptorBuilder.newBuilder(algorithm, 24);
    }

    public static PBECryptorBuilder newBuilder(PBECryptor.PBEAlgorithm algorithm, int passSize) {
        return PBECryptorBuilder.newBuilder(algorithm, GENERATOR.generate(passSize).toCharArray());
    }

    public static PBECryptorBuilder newBuilder(PBECryptor.PBEAlgorithm algorithm, char[] pass) {
        return PBECryptorBuilder.newBuilder(algorithm, pass, null);
    }

    public static PBECryptorBuilder newBuilder(PBECryptor.PBEAlgorithm algorithm, char[] pass, Provider provider) {
        return new PBECryptorBuilder(algorithm, pass, provider);
    }

    public PBECryptorBuilder mode(Mode mode) {
        this.mode = mode;
        return this;
    }

    public PBECryptorBuilder padding(Padding padding) {
        this.padding = padding;
        return this;
    }

    public PBECryptorBuilder parameter(byte[] salt, int iterations) {
        this.parameter = new PBEParameterSpec(salt, iterations);
        return this;
    }

    public PBECryptor build() {
        if (this.mode != null && this.padding == null) {
            throw new IllegalArgumentException("padding cannot be null within mode crypto.");
        }
        if (this.mode == null && this.padding != null) {
            throw new IllegalArgumentException("padding must be null without mode crypto.");
        }
        return new PBECryptor(this.secretKey, this.mode, this.padding, this.parameter, this.provider);
    }
}

