/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.jce.symmetric;

import code.ponfee.commons.jce.Providers;
import code.ponfee.commons.jce.symmetric.Mode;
import code.ponfee.commons.jce.symmetric.Padding;
import code.ponfee.commons.util.Base64UrlSafe;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class SymmetricCryptor {
    private final Mode mode;
    private final Padding padding;
    protected final AlgorithmParameterSpec parameter;
    private final Provider provider;
    private final SecretKey secretKey;
    private final String transformation;

    protected SymmetricCryptor(SecretKey secretKey, Mode mode, Padding padding, AlgorithmParameterSpec parameter, Provider provider) {
        this.secretKey = secretKey;
        this.mode = mode;
        this.padding = padding;
        this.parameter = parameter;
        this.provider = provider;
        this.transformation = mode != null ? this.getAlgorithm() + "/" + mode.name() + "/" + padding.padding() : this.getAlgorithm();
    }

    public final byte[] encrypt(byte[] data) {
        return this.docrypt(data, 1);
    }

    public final byte[] decrypt(byte[] encrypted) {
        return this.docrypt(encrypted, 2);
    }

    private byte[] docrypt(byte[] bytes, int cryptMode) {
        try {
            Cipher cipher = Providers.getCipher(this.transformation, this.provider);
            cipher.init(cryptMode, (Key)this.secretKey, this.parameter);
            return cipher.doFinal(bytes);
        }
        catch (GeneralSecurityException e) {
            throw new SecurityException(e);
        }
    }

    public final String getAlgorithm() {
        return this.secretKey.getAlgorithm();
    }

    public final byte[] getKey() {
        return this.secretKey.getEncoded();
    }

    public final String getKeyAsBase64() {
        return Base64UrlSafe.encode(this.getKey());
    }

    public byte[] getParameterAsBytes() {
        return ((IvParameterSpec)this.parameter).getIV();
    }

    public final String getParameterAsBase64() {
        return Base64UrlSafe.encode(this.getParameterAsBytes());
    }

    public final Mode getMode() {
        return this.mode;
    }

    public final Padding getPadding() {
        return this.padding;
    }

    public final Provider getProvider() {
        return this.provider;
    }
}

