/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.jce.symmetric;

import code.ponfee.commons.jce.Providers;
import code.ponfee.commons.jce.symmetric.Algorithm;
import code.ponfee.commons.jce.symmetric.Mode;
import code.ponfee.commons.jce.symmetric.Padding;
import code.ponfee.commons.jce.symmetric.SymmetricCryptor;
import code.ponfee.commons.util.SecureRandoms;
import java.security.Provider;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class SymmetricCryptorBuilder {
    private final SecretKey secretKey;
    private final Provider provider;
    private Mode mode;
    private Padding padding;
    private IvParameterSpec parameter;

    private SymmetricCryptorBuilder(Algorithm alg, byte[] key, Provider provider) {
        if (key == null) {
            KeyGenerator keyGenerator = Providers.getKeyGenerator(alg.name(), provider);
            this.secretKey = keyGenerator.generateKey();
        } else {
            this.secretKey = new SecretKeySpec(key, alg.name());
        }
        this.provider = provider;
    }

    public static SymmetricCryptorBuilder newBuilder(Algorithm algorithm) {
        return SymmetricCryptorBuilder.newBuilder(algorithm, null, null);
    }

    public static SymmetricCryptorBuilder newBuilder(Algorithm algorithm, Provider provider) {
        return SymmetricCryptorBuilder.newBuilder(algorithm, null, provider);
    }

    public static SymmetricCryptorBuilder newBuilder(Algorithm algorithm, int keySize) {
        return SymmetricCryptorBuilder.newBuilder(algorithm, SecureRandoms.nextBytes(keySize), null);
    }

    public static SymmetricCryptorBuilder newBuilder(Algorithm algorithm, int keySize, Provider provider) {
        return SymmetricCryptorBuilder.newBuilder(algorithm, SecureRandoms.nextBytes(keySize), provider);
    }

    public static SymmetricCryptorBuilder newBuilder(Algorithm algorithm, byte[] key) {
        return SymmetricCryptorBuilder.newBuilder(algorithm, key, null);
    }

    public static SymmetricCryptorBuilder newBuilder(Algorithm algorithm, byte[] key, Provider provider) {
        return new SymmetricCryptorBuilder(algorithm, key, provider);
    }

    public SymmetricCryptorBuilder mode(Mode mode) {
        this.mode = mode;
        return this;
    }

    public SymmetricCryptorBuilder padding(Padding padding) {
        this.padding = padding;
        return this;
    }

    public SymmetricCryptorBuilder parameter(byte[] parameter) {
        this.parameter = new IvParameterSpec(parameter);
        return this;
    }

    public SymmetricCryptor build() {
        if (this.mode != null && this.padding == null) {
            throw new IllegalArgumentException("padding cannot be null within mode crypto.");
        }
        if (this.mode == null && this.padding != null) {
            throw new IllegalArgumentException("padding must be null without mode crypto.");
        }
        return new SymmetricCryptor(this.secretKey, this.mode, this.padding, this.parameter, this.provider);
    }
}

