/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.limit.current;

import code.ponfee.commons.limit.current.CurrentLimiter;
import code.ponfee.commons.util.SynchronizedCaches;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class GuavaCurrentLimiter
implements CurrentLimiter {
    private static final ConcurrentMap<String, RateLimiter> LIMITER_MAP = new ConcurrentHashMap<String, RateLimiter>();

    @Override
    public boolean checkpoint(String key) {
        RateLimiter limiter = (RateLimiter)LIMITER_MAP.get(key);
        return limiter == null || limiter.tryAcquire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkpoint(String key, long requestThreshold) {
        if (requestThreshold < 0L) {
            return true;
        }
        if (requestThreshold == 0L) {
            return false;
        }
        RateLimiter limiter = SynchronizedCaches.get(key, LIMITER_MAP, () -> RateLimiter.create((double)requestThreshold));
        if (Double.valueOf(limiter.getRate()).longValue() != requestThreshold) {
            RateLimiter rateLimiter = limiter;
            synchronized (rateLimiter) {
                if (Double.valueOf(limiter.getRate()).longValue() != requestThreshold) {
                    limiter.setRate((double)requestThreshold);
                }
            }
        }
        return limiter.tryAcquire();
    }

    @Override
    public long countByRange(String key, Date from, Date to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRequestThreshold(String key, long threshold) {
        if (threshold < -1L) {
            LIMITER_MAP.remove(key);
        }
        SynchronizedCaches.get(key, LIMITER_MAP, () -> RateLimiter.create((double)threshold)).setRate((double)threshold);
    }

    @Override
    public long getRequestThreshold(String key) {
        RateLimiter limiter = (RateLimiter)LIMITER_MAP.get(key);
        if (limiter == null) {
            return -1L;
        }
        return Double.valueOf(limiter.getRate()).longValue();
    }
}

