/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.limit.request;

import code.ponfee.commons.limit.request.RequestLimitException;
import code.ponfee.commons.limit.request.RequestLimiter;
import code.ponfee.commons.util.Asserts;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;

public final class ConcurrentMapRequestLimiter
extends RequestLimiter {
    private final ConcurrentMap<String, RequestLimiter.CacheValue<?>> cache = new ConcurrentHashMap();
    private final Lock lock = new ReentrantLock();

    private ConcurrentMapRequestLimiter(ScheduledExecutorService scheduler) {
        Asserts.notNull((Object)scheduler, (String)"Scheduler cannot be null.");
        scheduler.scheduleAtFixedRate(() -> {
            if (!this.lock.tryLock()) {
                return;
            }
            try {
                long now = System.currentTimeMillis();
                this.cache.entrySet().removeIf(x -> ((RequestLimiter.CacheValue)x.getValue()).isExpire(now));
            }
            finally {
                this.lock.unlock();
            }
        }, 60L, 120L, TimeUnit.SECONDS);
    }

    @Override
    public ConcurrentMapRequestLimiter limitFrequency(String key, int period, String message) throws RequestLimitException {
        this.checkLimit("req:lmt:fre:" + key, period, 1, message);
        return this;
    }

    @Override
    public ConcurrentMapRequestLimiter limitThreshold(String key, int period, int limit, String message) throws RequestLimitException {
        this.checkLimit("req:lmt:thr:" + key, period, limit, message);
        return this;
    }

    @Override
    public void cacheCode(String key, String code, int ttl) {
        this.add("req:cah:code:" + key, code, ttl);
        this.remove("req:chk:code:" + key);
    }

    @Override
    public ConcurrentMapRequestLimiter checkCode(String key, String code, int limit) throws RequestLimitException {
        if (StringUtils.isEmpty((CharSequence)code)) {
            throw new RequestLimitException("\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String cacheKey = "req:cah:code:" + key;
        RequestLimiter.CacheValue actual = this.get(cacheKey);
        if (actual == null || actual.get() == null) {
            throw new RequestLimitException("\u9a8c\u8bc1\u7801\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\uff01");
        }
        String checkKey = "req:chk:code:" + key;
        RequestLimiter.CacheValue<?> times = this.incrementAndGet(checkKey, actual.expireTimeMillis);
        if (times.count() > limit) {
            this.remove(cacheKey, checkKey);
            throw new RequestLimitException("\u9a8c\u8bc1\u9519\u8bef\u6b21\u6570\u8fc7\u591a\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\uff01");
        }
        if (!((String)actual.get()).equals(code)) {
            throw new RequestLimitException("\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        }
        this.remove(cacheKey, checkKey);
        return this;
    }

    @Override
    public void cacheCaptcha(String key, String captcha, int expire) {
        this.add("req:cah:cap:" + key, captcha, expire);
    }

    @Override
    public boolean checkCaptcha(String key, String captcha, boolean caseSensitive) {
        RequestLimiter.CacheValue value = this.getAndRemove("req:cah:cap:" + key);
        if (value == null || value.get() == null) {
            return false;
        }
        return caseSensitive ? ((String)value.get()).equals(captcha) : ((String)value.get()).equalsIgnoreCase(captcha);
    }

    @Override
    public void recordAction(String key, int period) {
        this.incrementAndGet("req:cnt:act:" + key, ConcurrentMapRequestLimiter.expire(period));
    }

    @Override
    public long countAction(String key) {
        RequestLimiter.CacheValue cache = this.get("req:cnt:act:" + key);
        return cache == null ? 0L : (long)cache.count();
    }

    @Override
    public void resetAction(String key) {
        this.remove("req:cnt:act:" + key);
    }

    private void checkLimit(String key, int ttl, int limit, String message) throws RequestLimitException {
        RequestLimiter.CacheValue<?> cache = this.incrementAndGet(key, ConcurrentMapRequestLimiter.expire(ttl));
        if (cache.count() > limit) {
            throw new RequestLimitException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestLimiter.CacheValue<?> incrementAndGet(String key, long expireTimeMillis) {
        RequestLimiter.CacheValue<Object> value = (RequestLimiter.CacheValue<Object>)this.cache.get(key);
        if (value == null || value.isExpire()) {
            ConcurrentMap<String, RequestLimiter.CacheValue<?>> concurrentMap = this.cache;
            synchronized (concurrentMap) {
                value = (RequestLimiter.CacheValue)this.cache.get(key);
                if (value == null || value.isExpire()) {
                    value = new RequestLimiter.CacheValue<Object>(null, expireTimeMillis);
                    this.cache.put(key, value);
                    return value;
                }
            }
        }
        value.increment();
        return value;
    }

    private void remove(String ... keys) {
        for (String key : keys) {
            this.cache.remove(key);
        }
    }

    private <T> RequestLimiter.CacheValue<T> getAndRemove(String key) {
        RequestLimiter.CacheValue value = (RequestLimiter.CacheValue)this.cache.remove(key);
        return value == null || value.isExpire() ? null : value;
    }

    private <T> void add(String key, T value, int ttl) {
        this.cache.put(key, new RequestLimiter.CacheValue<T>(value, ConcurrentMapRequestLimiter.expire(ttl)));
    }

    private <T> RequestLimiter.CacheValue<T> get(String key) {
        RequestLimiter.CacheValue value = (RequestLimiter.CacheValue)this.cache.get(key);
        if (value == null) {
            return null;
        }
        if (value.isExpire()) {
            this.cache.remove(key);
            return null;
        }
        return value;
    }
}

