/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.log;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
public @interface LogAnnotation {
    public LogType type() default LogType.UNDEFINED;

    public boolean enabled() default false;

    public String desc() default "";

    public static enum LogType {
        UNDEFINED(0, null),
        ADD(1, "\u65b0\u589e"),
        UPDATE(2, "\u66f4\u65b0"),
        DELETE(3, "\u5220\u9664"),
        QUERY(4, "\u67e5\u8be2");

        private final int type;
        private final String comment;

        private LogType(int type, String comment) {
            this.type = type;
            this.comment = comment;
        }

        public String comment() {
            return this.comment;
        }

        public int type() {
            return this.type;
        }
    }
}

