/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.model;

import code.ponfee.commons.model.AbstractDataConverter;
import code.ponfee.commons.model.Page;
import code.ponfee.commons.model.Result;
import code.ponfee.commons.reflect.Fields;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MapDataConverter<S>
extends AbstractDataConverter<S, Map<String, Object>> {
    private final String[] fields;

    public MapDataConverter(String ... fields) {
        this.fields = fields;
    }

    @Override
    public Map<String, Object> convert(S source) {
        return MapDataConverter.convert(source, this.fields);
    }

    public static <S> Map<String, Object> convert(S source, String ... fields) {
        Function<String, Object> vm = source instanceof Map ? ((Map)source)::get : (source instanceof Dictionary ? ((Dictionary)source)::get : field -> Fields.get(source, field));
        return Arrays.stream(fields).collect(Collectors.toMap(Function.identity(), vm));
    }

    public static <S> List<Map<String, Object>> convert(List<S> list, String ... fields) {
        if (list == null) {
            return null;
        }
        return list.stream().map(e -> MapDataConverter.convert(e, fields)).collect(Collectors.toList());
    }

    public static <S> Page<Map<String, Object>> convert(Page<S> page, String ... fields) {
        if (page == null) {
            return null;
        }
        return page.map(x -> MapDataConverter.convert(x, fields));
    }

    public static <S> Result<Map<String, Object>> convertResultBean(Result<S> result, String ... fields) {
        if (result == null) {
            return null;
        }
        return result.from(MapDataConverter.convert(result.getData(), fields));
    }

    public static <S> Result<List<Map<String, Object>>> convertResultList(Result<List<S>> result, String ... fields) {
        if (result == null) {
            return null;
        }
        return result.from(MapDataConverter.convert(result.getData(), fields));
    }

    public static <S> Result<Page<Map<String, Object>>> convertResultPage(Result<Page<S>> result, String ... fields) {
        if (result == null) {
            return null;
        }
        return result.from(MapDataConverter.convert(result.getData(), fields));
    }
}

