/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.parser;

import code.ponfee.commons.parser.DateUDF;
import com.google.common.base.CaseFormat;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class ELParser {
    private static final Pattern PARAMS_PATTERN = Pattern.compile("\\$\\{\\s*([a-zA-Z0-9_\\-.]+)\\s*\\}");
    private static final Pattern DATETM_PATTERN = Pattern.compile("\\$\\[\\s*([a-zA-Z0-9_,\\-+.()\\s]+)\\s*\\]");
    private static final Pattern SPEL_PATTERN = Pattern.compile("\\{\\{\\s*([^{}]+)\\s*\\}\\}");

    public static String parse(String text) {
        return ELParser.parseDateUDF(text);
    }

    public static String parse(String text, Map<String, ?> params) {
        text = ELParser.parseParams(text, params);
        text = ELParser.parseSpel(text, params);
        text = ELParser.parseDateUDF(text);
        return text;
    }

    private static String parseParams(String text, Map<String, ?> params) {
        if (MapUtils.isEmpty(params)) {
            return text;
        }
        String result = text;
        Matcher matcher = PARAMS_PATTERN.matcher(text);
        while (matcher.find()) {
            String name = matcher.group(1);
            if (!params.containsKey(name)) continue;
            result = StringUtils.replace((String)result, (String)matcher.group(), (String)Objects.toString(params.get(name), ""));
        }
        return result;
    }

    private static String parseDateUDF(String text) {
        Matcher matcher = DATETM_PATTERN.matcher(text);
        String result = text;
        while (matcher.find()) {
            String val = ELParser.translate(matcher.group(1));
            if (val == null) continue;
            result = StringUtils.replace((String)result, (String)matcher.group(), (String)val);
        }
        return result;
    }

    private static String parseSpel(String text, Map<String, ?> params) {
        if (MapUtils.isEmpty(params)) {
            return text;
        }
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setVariables(params);
        SpelExpressionParser parser = new SpelExpressionParser();
        String result = text;
        Matcher matcher = SPEL_PATTERN.matcher(text);
        while (matcher.find()) {
            result = StringUtils.replace((String)result, (String)matcher.group(), (String)Objects.toString(parser.parseExpression(matcher.group(1)).getValue((EvaluationContext)context), null));
        }
        return result;
    }

    private static String translate(String text) {
        try {
            text = text.trim();
            int argsStart = text.indexOf(40);
            if (argsStart < 1) {
                return DateUDF.now(text);
            }
            if (!text.endsWith(")")) {
                return null;
            }
            String methodName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, text.substring(0, argsStart).trim().toLowerCase());
            String[] params = text.substring(argsStart + 1, text.lastIndexOf(41)).split(",");
            if (params.length == 1) {
                return (String)ELParser.getPublicStaticMethod(DateUDF.class, methodName, String.class).invoke(null, params[0].trim());
            }
            if (params.length == 2) {
                return (String)ELParser.getPublicStaticMethod(DateUDF.class, methodName, String.class, String.class).invoke(null, params[0].trim(), params[1].trim());
            }
            return null;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private static Method getPublicStaticMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws Exception {
        Method method = ArrayUtils.isEmpty((Object[])parameterTypes) ? clazz.getDeclaredMethod(methodName, new Class[0]) : clazz.getDeclaredMethod(methodName, parameterTypes);
        int modifiers = method.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) ? method : null;
    }
}

