/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.reflect;

import code.ponfee.commons.reflect.Fields;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class BeanConverts {
    public static <E> Object[] toArray(E bean, String ... fields) {
        if (bean == null || fields == null) {
            return null;
        }
        return Stream.of(fields).map(f -> Fields.get(bean, f)).toArray();
    }

    public static <T, E> List<T> toList(List<E> beans, String field) {
        if (beans == null) {
            return null;
        }
        return beans.stream().map(e -> Fields.get(e, field)).collect(Collectors.toList());
    }

    public static <E> List<Object[]> toList(List<E> beans, String ... fields) {
        if (beans == null || fields == null || fields.length == 0) {
            return null;
        }
        return beans.stream().map(e -> Stream.of(fields).map(f -> Fields.get(e, f)).toArray()).collect(Collectors.toList());
    }

    public static <K, V, E> Map<K, V> toMap(E bean, String keyField, String valueField) {
        if (bean == null) {
            return null;
        }
        return ImmutableMap.of((Object)Fields.get(bean, keyField), (Object)Fields.get(bean, valueField));
    }

    public static <K, V, E> Map<K, V> toMap(List<E> beans, String keyField, String valueField) {
        if (beans == null) {
            return null;
        }
        return beans.stream().collect(Collectors.toMap((? super T e) -> Fields.get(e, keyField), (? super T e) -> Fields.get(e, valueField)));
    }

    public static <K, E> Map<K, E> toMap(List<E> beans, String keyField) {
        if (beans == null) {
            return null;
        }
        return beans.stream().collect(Collectors.toMap((? super T e) -> Fields.get(e, keyField), Function.identity()));
    }
}

