/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.reflect;

import code.ponfee.commons.base.tuple.Tuple2;
import code.ponfee.commons.reflect.ClassUtils;
import code.ponfee.commons.util.SynchronizedCaches;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.cglib.beans.BeanCopier;

public class BeanCopiers {
    private static final Map<Tuple2<Class<?>, Class<?>>, BeanCopier> COPIER_CACHES = new HashMap();

    public static BeanCopier get(Class<?> sourceType, Class<?> targetType) {
        Tuple2<Class<?>, Class<?>> key = Tuple2.of(sourceType, targetType);
        return SynchronizedCaches.get(key, COPIER_CACHES, () -> BeanCopier.create((Class)sourceType, (Class)targetType, (boolean)false));
    }

    public static void copy(Object source, Object target) {
        BeanCopiers.get(source.getClass(), target.getClass()).copy(source, target, null);
    }

    public static <T> T copy(Object source, Supplier<T> supplier) {
        T target = supplier.get();
        BeanCopiers.copy(source, target);
        return target;
    }

    public static <T> T copy(Object source, Class<T> targetType) {
        T target = ClassUtils.newInstance(targetType);
        BeanCopiers.copy(source, target);
        return target;
    }
}

