/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.spring;

import code.ponfee.commons.math.Numbers;
import code.ponfee.commons.model.PageParameter;
import code.ponfee.commons.reflect.Fields;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PageMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final int DEFAULT_SIZE = 20;
    private static final List<String> SIZE_PARAMS = ImmutableList.of((Object)"pageSize", (Object)"limit");

    public boolean supportsParameter(MethodParameter parameter) {
        return PageParameter.class == parameter.getParameterType();
    }

    public PageParameter resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        Map params = webRequest.getParameterMap();
        PageParameter pp = new PageParameter(params.size(), 1);
        params.forEach((key, value) -> {
            if (PageParameter.PAGE_PARAMS.contains(key)) {
                int value0 = Numbers.toInt(value[0], 0);
                if (value0 < 1 && SIZE_PARAMS.contains(key)) {
                    value0 = 20;
                }
                Fields.put((Object)pp, key, (Object)value0);
                pp.put((String)key, value0);
            } else if ("sort".equalsIgnoreCase((String)key)) {
                String value0 = StringUtils.join((Object[])value, (char)',').trim();
                Fields.put((Object)pp, "sort", (Object)value0);
                pp.put("sort", value0);
            } else {
                pp.put((String)key, ((String[])value).length == 1 ? value[0].trim() : value);
            }
        });
        if (pp.getLimit() > 0) {
            if (pp.getLimit() > 1000) {
                pp.setLimit(1000);
            }
            if (pp.getOffset() < 0) {
                pp.setOffset(0);
            }
        } else {
            if (pp.getPageSize() < 1) {
                pp.setPageSize(20);
            } else if (pp.getPageSize() > 1000) {
                pp.setPageSize(1000);
            }
            if (pp.getPageNum() < 1) {
                pp.setPageNum(1);
            }
        }
        return pp;
    }
}

