/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.spring;

import code.ponfee.commons.model.TypedMap;
import code.ponfee.commons.spring.YamlPropertySourceFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class YamlProperties
extends Properties
implements TypedMap<Object, Object> {
    public YamlProperties(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            this.loadYaml(inputStream);
        }
    }

    public YamlProperties(InputStream inputStream) {
        this.loadYaml(inputStream);
    }

    public YamlProperties(String content) {
        this.loadYaml(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));
    }

    private void loadYaml(InputStream inputStream) {
        InputStreamResource resource = new InputStreamResource(inputStream);
        super.putAll((Map<?, ?>)YamlPropertySourceFactory.loadYml((Resource)resource));
    }
}

