/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.util;

import code.ponfee.commons.jce.digest.DigestUtils;
import code.ponfee.commons.util.Bytes;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public class Base58 {
    private static final char[] ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".toCharArray();
    private static final int LENGTH = ALPHABET.length;
    private static final int[] INDEXES = new int[128];

    public static String encode(byte[] data) {
        int zeroCount;
        if (data.length == 0) {
            return "";
        }
        data = Arrays.copyOfRange(data, 0, data.length);
        for (zeroCount = 0; zeroCount < data.length && data[zeroCount] == 0; ++zeroCount) {
        }
        byte[] temp = new byte[data.length << 1];
        int j = temp.length;
        int startAt = zeroCount;
        while (startAt < data.length) {
            int mod = Base58.divmod58(data, startAt);
            if (data[startAt] == 0) {
                ++startAt;
            }
            temp[--j] = (byte)ALPHABET[mod];
        }
        while (j < temp.length && temp[j] == ALPHABET[0]) {
            ++j;
        }
        while (--zeroCount >= 0) {
            temp[--j] = (byte)ALPHABET[0];
        }
        return new String(temp, j, temp.length - j, StandardCharsets.US_ASCII);
    }

    public static byte[] decode(String data) {
        int zeroCount;
        if (data.length() == 0) {
            return new byte[0];
        }
        byte[] input58 = new byte[data.length()];
        for (int i = 0; i < data.length(); ++i) {
            char c = data.charAt(i);
            int digit58 = -1;
            if (c >= '\u0000' && c < '\u0080') {
                digit58 = INDEXES[c];
            }
            if (digit58 < 0) {
                throw new IllegalArgumentException("Illegal character '" + c + "' at [" + i + "]");
            }
            input58[i] = (byte)digit58;
        }
        for (zeroCount = 0; zeroCount < input58.length && input58[zeroCount] == 0; ++zeroCount) {
        }
        byte[] temp = new byte[data.length()];
        int j = temp.length;
        int startAt = zeroCount;
        while (startAt < input58.length) {
            byte mod = Base58.divmod256(input58, startAt);
            if (input58[startAt] == 0) {
                ++startAt;
            }
            temp[--j] = mod;
        }
        while (j < temp.length && temp[j] == 0) {
            ++j;
        }
        return Arrays.copyOfRange(temp, j - zeroCount, temp.length);
    }

    public static BigInteger decodeToBigInteger(String data) {
        return Bytes.toBigInteger(Base58.decode(data));
    }

    public static String encodeChecked(byte[] data) {
        return Base58.encode(ArrayUtils.addAll((byte[])data, (byte[])Base58.checksum(data)));
    }

    public static byte[] decodeChecked(String data) {
        byte[] decoded = Base58.decode(data);
        if (decoded.length < 4) {
            throw new IllegalArgumentException("Data too short.");
        }
        int bounds = decoded.length - 4;
        byte[] origin = Arrays.copyOfRange(decoded, 0, bounds);
        byte[] checksum = Arrays.copyOfRange(decoded, bounds, decoded.length);
        if (!Arrays.equals(checksum, Base58.checksum(origin))) {
            throw new IllegalArgumentException("Invalid checksum.");
        }
        return origin;
    }

    private static int divmod58(byte[] number, int startAt) {
        int remainder = 0;
        for (int i = startAt; i < number.length; ++i) {
            int digit256 = number[i] & 0xFF;
            int temp = (remainder << 8) + digit256;
            number[i] = (byte)(temp / LENGTH);
            remainder = temp % LENGTH;
        }
        return remainder;
    }

    private static byte divmod256(byte[] number58, int startAt) {
        int remainder = 0;
        for (int i = startAt; i < number58.length; ++i) {
            int digit58 = number58[i] & 0xFF;
            int temp = remainder * LENGTH + digit58;
            number58[i] = (byte)(temp / 256);
            remainder = temp & 0xFF;
        }
        return (byte)remainder;
    }

    private static byte[] checksum(byte[] data) {
        byte[] twiceSha256 = DigestUtils.sha256(DigestUtils.sha256(data));
        return Arrays.copyOfRange(twiceSha256, 0, 4);
    }

    static {
        Arrays.fill(INDEXES, -1);
        for (int i = 0; i < LENGTH; ++i) {
            Base58.INDEXES[Base58.ALPHABET[i]] = i;
        }
    }
}

