/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.util;

import code.ponfee.commons.util.ObjectUtils;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailRetryTemplate {
    private static final Logger LOG = LoggerFactory.getLogger(FailRetryTemplate.class);

    public static <T> T execute(Supplier<T> normal, Supplier<String> message) throws Exception {
        return FailRetryTemplate.execute(normal, normal, 5, message);
    }

    public static <T> T execute(Supplier<T> normal, Supplier<T> fallback, int failRetryCount, Supplier<String> message) throws Exception {
        int i = 0;
        String logMsg = null;
        while (true) {
            try {
                if (i == 0) {
                    return normal.get();
                }
                return fallback.get();
            }
            catch (Exception e) {
                Exception ex = e;
                if (i >= failRetryCount) continue;
                if (logMsg == null) {
                    logMsg = ObjectUtils.uuid32() + " - " + message.get();
                }
                int count = i + 1;
                LOG.error("Execute failed, will retrying - " + count + " - " + logMsg, (Throwable)e);
                Thread.sleep(5000L * (long)count);
                if (++i <= failRetryCount) continue;
                throw ex;
            }
            break;
        }
    }
}

