/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.util;

import code.ponfee.commons.util.CurrencyEnum;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Currency;
import java.util.stream.LongStream;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Money
implements Serializable,
Comparable<Money>,
Cloneable {
    private static final long serialVersionUID = 7743331479636754564L;
    private static final RoundingMode DEFAULT_ROUNDING_MODE = RoundingMode.HALF_EVEN;
    private static final int[] FACTORS = new int[]{1, 10, 100, 1000, 10000, 100000};
    private final Currency currency;
    private long number;

    public Money(Currency currency, long majorUnitNumber, int minorUnitNumber) {
        if (currency == null) {
            throw new IllegalArgumentException("Currency cannot null.");
        }
        int factor = this.getFactor();
        if (minorUnitNumber >= factor) {
            throw new RuntimeException("Minor[" + minorUnitNumber + "] must less than factor[" + factor + "].");
        }
        this.currency = currency;
        this.number = majorUnitNumber * (long)factor + (long)minorUnitNumber;
    }

    public Money(Currency currency, long number) {
        if (currency == null) {
            throw new IllegalArgumentException("Currency cannot null.");
        }
        this.currency = currency;
        this.number = number;
    }

    public static Money of(Currency currency, long number) {
        return new Money(currency, number);
    }

    public static Money of(CurrencyEnum currencyEnum, long number) {
        return new Money(currencyEnum.currency(), number);
    }

    public static Money of(String currencyCode, long number) {
        return new Money(Currency.getInstance(currencyCode), number);
    }

    public Money ofMajor(CurrencyEnum currencyEnum, String majorUnitNumber, RoundingMode roundingMode) {
        return Money.ofMajor(currencyEnum.currency(), new BigDecimal(majorUnitNumber), roundingMode);
    }

    public Money ofMajor(String currencyCode, String majorUnitNumber, RoundingMode roundingMode) {
        return Money.ofMajor(Currency.getInstance(currencyCode), new BigDecimal(majorUnitNumber), roundingMode);
    }

    public Money ofMajor(Currency currency, String majorUnitNumber, RoundingMode roundingMode) {
        return Money.ofMajor(currency, new BigDecimal(majorUnitNumber), roundingMode);
    }

    public static Money ofMajor(CurrencyEnum currencyEnum, BigDecimal majorUnitNumber, RoundingMode roundingMode) {
        return Money.ofMajor(currencyEnum.currency(), majorUnitNumber, roundingMode);
    }

    public static Money ofMajor(String currencyCode, BigDecimal majorUnitNumber, RoundingMode roundingMode) {
        return Money.ofMajor(Currency.getInstance(currencyCode), majorUnitNumber, roundingMode);
    }

    public static Money ofMajor(Currency currency, BigDecimal majorUnitNumber, RoundingMode roundingMode) {
        long number = Money.rounding(majorUnitNumber.movePointRight(currency.getDefaultFractionDigits()), roundingMode);
        return new Money(currency, number);
    }

    public static Money zero(Currency currency) {
        return new Money(currency, 0L);
    }

    public static Money zero(CurrencyEnum currencyEnum) {
        return Money.zero(currencyEnum.currency());
    }

    public static Money zero(String currencyCode) {
        return Money.zero(Currency.getInstance(currencyCode));
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public long getNumber() {
        return this.number;
    }

    public final String getCurrencyCode() {
        return this.currency.getCurrencyCode();
    }

    public void setNumber(long number) {
        this.number = number;
    }

    public final int getFactor() {
        return FACTORS[this.currency.getDefaultFractionDigits()];
    }

    public BigDecimal toMajorNumber() {
        return BigDecimal.valueOf(this.number, this.currency.getDefaultFractionDigits());
    }

    public String toMajorString() {
        return this.toMajorNumber().toString();
    }

    public boolean equals(Object other) {
        return other instanceof Money && this.equals((Money)other);
    }

    public boolean equals(Money other) {
        if (other == null) {
            return false;
        }
        return this.currency.equals(other.currency) && this.number == other.number;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.currency).append(this.number).toHashCode();
    }

    public Money clone() {
        return new Money(this.currency, this.number);
    }

    public String toString() {
        return CurrencyEnum.ofCurrency(this.currency).currencySymbol() + this.toMajorString();
    }

    @Override
    public int compareTo(Money other) {
        this.assertSameCurrency(other);
        return Long.compare(this.number, other.number);
    }

    public boolean greaterThan(Money other) {
        return this.compareTo(other) > 0;
    }

    public Money add(Money other) {
        this.assertSameCurrency(other);
        return this.create(this.number + other.number);
    }

    public Money addTo(Money other) {
        this.assertSameCurrency(other);
        this.number += other.number;
        return this;
    }

    public Money subtract(Money other) {
        this.assertSameCurrency(other);
        return this.create(this.number - other.number);
    }

    public Money subtractFrom(Money other) {
        this.assertSameCurrency(other);
        this.number -= other.number;
        return this;
    }

    public Money multiply(long val) {
        return this.create(this.number * val);
    }

    public Money multiplyBy(long val) {
        this.number *= val;
        return this;
    }

    public Money multiply(BigDecimal val) {
        return this.multiply(val, DEFAULT_ROUNDING_MODE);
    }

    public Money multiplyBy(BigDecimal val) {
        return this.multiplyBy(val, DEFAULT_ROUNDING_MODE);
    }

    public Money multiply(BigDecimal val, RoundingMode roundingMode) {
        return this.create(Money.rounding(BigDecimal.valueOf(this.number).multiply(val), roundingMode));
    }

    public Money multiplyBy(BigDecimal val, RoundingMode roundingMode) {
        this.number = Money.rounding(BigDecimal.valueOf(this.number).multiply(val), roundingMode);
        return this;
    }

    public Money divide(BigDecimal val) {
        return this.divide(val, DEFAULT_ROUNDING_MODE);
    }

    public Money divide(BigDecimal val, RoundingMode roundingMode) {
        return this.create(BigDecimal.valueOf(this.number).divide(val, roundingMode).longValue());
    }

    public Money divideBy(BigDecimal val) {
        return this.divideBy(val, DEFAULT_ROUNDING_MODE);
    }

    public Money divideBy(BigDecimal val, RoundingMode roundingMode) {
        this.number = BigDecimal.valueOf(this.number).divide(val, roundingMode).longValue();
        return this;
    }

    public Money[] slice(int segment) {
        int i;
        Money[] results = new Money[segment];
        long low = this.number / (long)segment;
        long high = low + 1L;
        int remainder = (int)this.number % segment;
        for (i = 0; i < remainder; ++i) {
            results[i] = this.create(high);
        }
        for (i = remainder; i < segment; ++i) {
            results[i] = this.create(low);
        }
        return results;
    }

    public Money[] slice(long[] ratios) {
        int i;
        Money[] results = new Money[ratios.length];
        long total = LongStream.of(ratios).sum();
        long remainder = this.number;
        for (i = 0; i < results.length; ++i) {
            results[i] = this.create(this.number * ratios[i] / total);
            remainder -= results[i].number;
        }
        i = 0;
        while ((long)i < remainder) {
            ++results[i].number;
            ++i;
        }
        return results;
    }

    private void assertSameCurrency(Money other) {
        if (!this.currency.equals(other.currency)) {
            throw new IllegalArgumentException("Money math currency mismatch.");
        }
    }

    private Money create(long number) {
        return new Money(this.currency, number);
    }

    private static long rounding(BigDecimal val, RoundingMode roundingMode) {
        return val.setScale(0, roundingMode).longValue();
    }
}

