/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class RegexUtils {
    private static final Pattern PATTERN_USERNAME = Pattern.compile("^[0-9A-Za-z_\\-]{4,20}$");
    private static final String SYMBOL = "@#!%&_\\.\\?\\-\\$\\^\\*";
    private static final Pattern PATTERN_PASSWORD = Pattern.compile("^((?=.*\\d)(?=.*[A-Za-z])|(?=.*\\d)(?=.*[@#!%&_\\.\\?\\-\\$\\^\\*])|(?=.*[A-Za-z])(?=.*[@#!%&_\\.\\?\\-\\$\\^\\*]))[\\dA-Za-z@#!%&_\\.\\?\\-\\$\\^\\*]{8,20}$");
    private static final Pattern PATTERN_MOBILE = Pattern.compile("^\\s*(((\\+)?86)|(\\((\\+)?86\\)))?1\\d{10}\\s*$");
    private static final Pattern CHINA_TELECOM_PATTERN = Pattern.compile("(^1(33|53|77|73|99|8[019])\\d{8}$)|(^1700\\d{7}$)");
    private static final Pattern CHINA_UNICOM_PATTERN = Pattern.compile("(^1(3[0-2]|4[5]|5[56]|7[6]|8[56])\\d{8}$)|(^1709\\d{7}$)");
    private static final Pattern CHINA_MOBILE_PATTERN = Pattern.compile("(^1(3[4-9]|4[7]|5[0-27-9]|7[8]|8[2-478])\\d{8}$)|(^1705\\d{7}$)");
    private static final Pattern PATTERN_EMAIL = Pattern.compile("^\\w+((-\\w+)|(\\.\\w+))*\\@[A-Za-z0-9]+((\\.|-)[A-Za-z0-9]+)*\\.[A-Za-z0-9]+$");
    private static final Pattern PATTERN_IPV4 = Pattern.compile("(?:(?:2[0-4][0-9]\\.)|(?:25[0-5]\\.)|(?:1[0-9][0-9]\\.)|(?:[1-9][0-9]\\.)|(?:[0-9]\\.)){3}(?:(?:2[0-4][0-9])|(?:25[0-5])|(?:1[0-9][0-9])|(?:[1-9][0-9])|(?:[0-9]))");
    private static final Pattern PATTERN_IPV6 = Pattern.compile("^([0-9a-fA-F]{1,4}:){7}([0-9a-fA-F]{1,4}|:)|([0-9a-fA-F]{1,4}:){1,6}(:[0-9a-fA-F]{1,4}|:)|([0-9a-fA-F]{1,4}:){1,5}((:[0-9a-fA-F]{1,4}){1,2}|:)|([0-9a-fA-F]{1,4}:){1,4}((:[0-9a-fA-F]{1,4}){1,3}|:)|([0-9a-fA-F]{1,4}:){1,3}((:[0-9a-fA-F]{1,4}){1,4}|:)|([0-9a-fA-F]{1,4}:){1,2}((:[0-9a-fA-F]{1,4}){1,5}|:)|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6}|:)|:((:[0-9a-fA-F]{1,4}){1,7}|:)");
    private static final Pattern PATTERN_DATE = Pattern.compile("^([1-9]\\d{3}((0[1-9]|1[012])(0[1-9]|1\\d|2[0-8])|(0[13456789]|1[012])(29|30)|(0[13578]|1[02])31)|(([2-9]\\d)(0[48]|[2468][048]|[13579][26])|(([2468][048]|[3579][26])00))0229)(([0-1][0-9]|2[0-3])([0-5][0-9])([0-5][0-9])(\\d{3})?)?$");
    private static final LoadingCache<String, Pattern> PATTERNS = CacheBuilder.newBuilder().softValues().build((CacheLoader)new CacheLoader<String, Pattern>(){

        public Pattern load(String pattern) {
            return Pattern.compile(pattern);
        }
    });

    public static String findFirst(String originalStr, String regex) {
        return RegexUtils.findGroup(originalStr, regex, 0);
    }

    public static String findGroup(String originalStr, String regex, int group) {
        if (originalStr == null || regex == null) {
            return "";
        }
        try {
            Matcher matcher = ((Pattern)PATTERNS.get((Object)regex)).matcher(originalStr);
            return matcher.find() ? matcher.group(group) : "";
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean matches(String originalStr, String regex) {
        if (originalStr == null || regex == null) {
            return false;
        }
        try {
            return ((Pattern)PATTERNS.get((Object)regex)).matcher(originalStr).matches();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isMobilePhone(String text) {
        return text != null && PATTERN_MOBILE.matcher(text).matches();
    }

    public static boolean isEmail(String text) {
        return text != null && PATTERN_EMAIL.matcher(text).matches();
    }

    public static boolean isIpv4(String text) {
        return text != null && PATTERN_IPV4.matcher(text).matches();
    }

    public static boolean isIpv6(String text) {
        return text != null && PATTERN_IPV6.matcher(text).matches();
    }

    public static boolean isValidUserName(String text) {
        return text != null && PATTERN_USERNAME.matcher(text).matches();
    }

    public static boolean isValidPassword(String text) {
        return text != null && PATTERN_PASSWORD.matcher(text).matches();
    }

    public static boolean isDatePattern(String text) {
        return text != null && PATTERN_DATE.matcher(text).matches();
    }

    public static int getPhoneCarrier(String mobilePhone) {
        if (StringUtils.isBlank((CharSequence)mobilePhone)) {
            return 0;
        }
        if (CHINA_MOBILE_PATTERN.matcher(mobilePhone).matches()) {
            return 1;
        }
        if (CHINA_UNICOM_PATTERN.matcher(mobilePhone).matches()) {
            return 2;
        }
        if (CHINA_TELECOM_PATTERN.matcher(mobilePhone).matches()) {
            return 3;
        }
        return 0;
    }
}

