/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.util;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public final class SynchronizedCaches {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> V get(K key, Map<K, V> cache, Function<K, V> mapper) {
        V val = cache.get(key);
        if (val != null) {
            return val;
        }
        Map<K, V> map = cache;
        synchronized (map) {
            val = cache.get(key);
            if (val == null && (val = mapper.apply(key)) != null) {
                cache.put(key, val);
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> V get(K key, Map<K, V> cache, Supplier<V> supplier) {
        V val = cache.get(key);
        if (val != null) {
            return val;
        }
        Map<K, V> map = cache;
        synchronized (map) {
            val = cache.get(key);
            if (val == null && (val = supplier.get()) != null) {
                cache.put(key, val);
            }
        }
        return val;
    }
}

