/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.ws.adapter;

import code.ponfee.commons.reflect.GenericUtils;
import code.ponfee.commons.ws.adapter.model.MapEntry;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public abstract class MapAdapter<K, V>
extends XmlAdapter<MapEntry[], Map<K, V>> {
    protected final Class<K> ktype = GenericUtils.getActualTypeArgument(((Object)((Object)this)).getClass(), 0);
    protected final Class<V> vtype = GenericUtils.getActualTypeArgument(((Object)((Object)this)).getClass(), 1);

    protected MapAdapter() {
    }

    public MapEntry<K, V>[] marshal(Map<K, V> map) {
        if (map == null) {
            return null;
        }
        MapEntry[] entries = new MapEntry[map.size()];
        int i = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            entries[i++] = new MapEntry<K, V>(entry);
        }
        return entries;
    }

    public Map<K, V> unmarshal(MapEntry[] entries) {
        if (entries == null) {
            return null;
        }
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (MapEntry e : entries) {
            map.put(e.getKey(), e.getValue());
        }
        return map;
    }
}

