/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.ws.adapter.model;

import code.ponfee.commons.model.Page;
import code.ponfee.commons.ws.adapter.model.ArrayItem;
import com.google.common.collect.Lists;
import java.lang.reflect.Array;
import java.util.ArrayList;

public class TransitPage<T> {
    private ArrayItem<T> rows;
    private int pageNum;
    private int pageSize;
    private int size;
    private long startRow;
    private long endRow;
    private long total;
    private int pages;
    private int prePage;
    private int nextPage;
    private boolean isFirstPage = false;
    private boolean isLastPage = false;
    private boolean hasPreviousPage = false;
    private boolean hasNextPage = false;
    private int navigatePages;
    private int[] navigatePageNums;
    private int navigateFirstPage;
    private int navigateLastPage;

    public ArrayItem<T> getRows() {
        return this.rows;
    }

    public void setRows(ArrayItem<T> rows) {
        this.rows = rows;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public long getStartRow() {
        return this.startRow;
    }

    public void setStartRow(long startRow) {
        this.startRow = startRow;
    }

    public long getEndRow() {
        return this.endRow;
    }

    public void setEndRow(long endRow) {
        this.endRow = endRow;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public int getPages() {
        return this.pages;
    }

    public void setPages(int pages) {
        this.pages = pages;
    }

    public int getPrePage() {
        return this.prePage;
    }

    public void setPrePage(int prePage) {
        this.prePage = prePage;
    }

    public int getNextPage() {
        return this.nextPage;
    }

    public void setNextPage(int nextPage) {
        this.nextPage = nextPage;
    }

    public boolean isFirstPage() {
        return this.isFirstPage;
    }

    public void setFirstPage(boolean isFirstPage) {
        this.isFirstPage = isFirstPage;
    }

    public boolean isLastPage() {
        return this.isLastPage;
    }

    public void setLastPage(boolean isLastPage) {
        this.isLastPage = isLastPage;
    }

    public boolean isHasPreviousPage() {
        return this.hasPreviousPage;
    }

    public void setHasPreviousPage(boolean hasPreviousPage) {
        this.hasPreviousPage = hasPreviousPage;
    }

    public boolean isHasNextPage() {
        return this.hasNextPage;
    }

    public void setHasNextPage(boolean hasNextPage) {
        this.hasNextPage = hasNextPage;
    }

    public int getNavigatePages() {
        return this.navigatePages;
    }

    public void setNavigatePages(int navigatePages) {
        this.navigatePages = navigatePages;
    }

    public int[] getNavigatePageNums() {
        return this.navigatePageNums;
    }

    public void setNavigatePageNums(int[] navigatePageNums) {
        this.navigatePageNums = navigatePageNums;
    }

    public int getNavigateFirstPage() {
        return this.navigateFirstPage;
    }

    public void setNavigateFirstPage(int navigateFirstPage) {
        this.navigateFirstPage = navigateFirstPage;
    }

    public int getNavigateLastPage() {
        return this.navigateLastPage;
    }

    public void setNavigateLastPage(int navigateLastPage) {
        this.navigateLastPage = navigateLastPage;
    }

    public static <T> TransitPage<T> transform(Page<T> page, Class<?> type) {
        Object[] array = (Object[])Array.newInstance(type, page.getRows().size());
        return TransitPage.transform(page, page.getRows().toArray(array));
    }

    public static <T> TransitPage<T> transform(Page<?> page, T[] t) {
        TransitPage<T> transit = new TransitPage<T>();
        transit.setRows(new ArrayItem<T>(t));
        TransitPage.copy(transit, page);
        return transit;
    }

    public static <T> Page<T> recover(TransitPage<T> transit) {
        Page page = new Page();
        ArrayList list = Lists.newArrayList((Object[])transit.getRows().getItem());
        page.setRows(list);
        page.setPageNum(transit.getPageNum());
        page.setPageSize(transit.getPageSize());
        page.setSize(transit.getSize());
        page.setStartRow(transit.getStartRow());
        page.setEndRow(transit.getEndRow());
        page.setTotal(transit.getTotal());
        page.setPages(transit.getPages());
        page.setPrePage(transit.getPrePage());
        page.setNextPage(transit.getNextPage());
        page.setFirstPage(transit.isFirstPage());
        page.setLastPage(transit.isLastPage());
        page.setHasPreviousPage(transit.isHasPreviousPage());
        page.setHasNextPage(transit.isHasNextPage());
        page.setNavigatePages(transit.getNavigatePages());
        page.setNavigatePageNums(transit.getNavigatePageNums());
        page.setNavigateFirstPage(transit.getNavigateFirstPage());
        page.setNavigateLastPage(transit.getNavigateLastPage());
        return page;
    }

    private static void copy(TransitPage<?> transit, Page<?> page) {
        transit.setPageNum(page.getPageNum());
        transit.setPageSize(page.getPageSize());
        transit.setSize(page.getSize());
        transit.setStartRow(page.getStartRow());
        transit.setEndRow(page.getEndRow());
        transit.setTotal(page.getTotal());
        transit.setPages(page.getPages());
        transit.setPrePage(page.getPrePage());
        transit.setNextPage(page.getNextPage());
        transit.setFirstPage(page.getFirstPage());
        transit.setLastPage(page.getLastPage());
        transit.setHasPreviousPage(page.getHasPreviousPage());
        transit.setHasNextPage(page.getHasNextPage());
        transit.setNavigatePages(page.getNavigatePages());
        transit.setNavigatePageNums(page.getNavigatePageNums());
        transit.setNavigateFirstPage(page.getNavigateFirstPage());
        transit.setNavigateLastPage(page.getNavigateLastPage());
    }
}

