/* __________              _____                                                *\
** \______   \____   _____/ ____\____   ____    Copyright (c) 2017-2023 Ponfee  **
**  |     ___/  _ \ /    \   __\/ __ \_/ __ \   http://www.ponfee.cn            **
**  |    |  (  <_> )   |  \  | \  ___/\  ___/   Apache License Version 2.0      **
**  |____|   \____/|___|  /__|  \___  >\___  >  http://www.apache.org/licenses/ **
**                      \/          \/     \/                                   **
\*                                                                              */

package code.ponfee.commons.jce;

/**
 * RSA加密填充
 * Jdk Sun only support：RSA/ECB/PKCS1Padding
 * 
 * @see org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherSpi
 * 
 * @author Ponfee
 */
public enum RSACipherPaddings {

    ECB_NOPADDING("/ECB/NOPADDING"), // 
    ECB_PKCS1PADDING("/ECB/PKCS1PADDING"), // 原文必须 比RSA钥模长(modulus)短至少11个字节
    ECB_ISO9796_1PADDING("/ECB/ISO9796-1PADDING"), // 
    ECB_OAEPWITHMD5ANDMGF1PADDING("/ECB/OAEPWITHMD5ANDMGF1PADDING"), // 
    ECB_OAEPPADDING("/ECB/OAEPPADDING"), // RSA_size(rsa) – 41
    ECB_OAEPWITHSHA1ANDMGF1PADDING("/ECB/OAEPWITHSHA1ANDMGF1PADDING"), // OAEPWITHSHA-1ANDMGF1PADDING
    ECB_OAEPWITHSHA224ANDMGF1PADDING("/ECB/OAEPWITHSHA224ANDMGF1PADDING"), // OAEPWITHSHA-224ANDMGF1PADDING
    ECB_OAEPWITHSHA256ANDMGF1PADDING("/ECB/OAEPWITHSHA256ANDMGF1PADDING"), // OAEPWITHSHA-256ANDMGF1PADDING
    ECB_OAEPWITHSHA384ANDMGF1PADDING("/ECB/OAEPWITHSHA384ANDMGF1PADDING"), // OAEPWITHSHA-384ANDMGF1PADDING
    ECB_OAEPWITHSHA512ANDMGF1PADDING("/ECB/OAEPWITHSHA512ANDMGF1PADDING"), // OAEPWITHSHA-512ANDMGF1PADDING
    ECB_OAEPWITHSHA3_224ANDMGF1PADDING("/ECB/OAEPWITHSHA3-224ANDMGF1PADDING"), // 
    ECB_OAEPWITHSHA3_256ANDMGF1PADDING("/ECB/OAEPWITHSHA3-256ANDMGF1PADDING"), // 
    ECB_OAEPWITHSHA3_384ANDMGF1PADDING("/ECB/OAEPWITHSHA3-384ANDMGF1PADDING"), // 
    ECB_OAEPWITHSHA3_512ANDMGF1PADDING("/ECB/OAEPWITHSHA3-512ANDMGF1PADDING"), // 

    NONE_NOPADDING("/NONE/NOPADDING"), // 
    NONE_PKCS1PADDING("/NONE/PKCS1PADDING"), // 原文必须 比RSA钥模长(modulus)短至少11个字节
    NONE_ISO9796_1PADDING("/NONE/ISO9796-1PADDING"), // 
    NONE_OAEPWITHMD5ANDMGF1PADDING("/NONE/OAEPWITHMD5ANDMGF1PADDING"), // 
    NONE_OAEPPADDING("/NONE/OAEPPADDING"), // RSA_size(rsa) – 41
    NONE_OAEPWITHSHA1ANDMGF1PADDING("/NONE/OAEPWITHSHA1ANDMGF1PADDING"), // OAEPWITHSHA-1ANDMGF1PADDING
    NONE_OAEPWITHSHA224ANDMGF1PADDING("/NONE/OAEPWITHSHA224ANDMGF1PADDING"), // OAEPWITHSHA-224ANDMGF1PADDING
    NONE_OAEPWITHSHA256ANDMGF1PADDING("/NONE/OAEPWITHSHA256ANDMGF1PADDING"), // OAEPWITHSHA-256ANDMGF1PADDING
    NONE_OAEPWITHSHA384ANDMGF1PADDING("/NONE/OAEPWITHSHA384ANDMGF1PADDING"), // OAEPWITHSHA-384ANDMGF1PADDING
    NONE_OAEPWITHSHA512ANDMGF1PADDING("/NONE/OAEPWITHSHA512ANDMGF1PADDING"), // OAEPWITHSHA-512ANDMGF1PADDING
    NONE_OAEPWITHSHA3_224ANDMGF1PADDING("/NONE/OAEPWITHSHA3-224ANDMGF1PADDING"), // 
    NONE_OAEPWITHSHA3_256ANDMGF1PADDING("/NONE/OAEPWITHSHA3-256ANDMGF1PADDING"), // 
    NONE_OAEPWITHSHA3_384ANDMGF1PADDING("/NONE/OAEPWITHSHA3-384ANDMGF1PADDING"), // 
    NONE_OAEPWITHSHA3_512ANDMGF1PADDING("/NONE/OAEPWITHSHA3-512ANDMGF1PADDING"), // 

    ECB_SSLV23("/ECB/SSLV23"), // 
    NONE_SSLV23("/NONE/SSLV23"); // 

    private final String transform;

    RSACipherPaddings(String transform) {
        this.transform = transform;
    }

    public String transform() {
        return transform;
    }
}
