/* __________              _____                                                *\
** \______   \____   _____/ ____\____   ____    Copyright (c) 2017-2023 Ponfee  **
**  |     ___/  _ \ /    \   __\/ __ \_/ __ \   http://www.ponfee.cn            **
**  |    |  (  <_> )   |  \  | \  ___/\  ___/   Apache License Version 2.0      **
**  |____|   \____/|___|  /__|  \___  >\___  >  http://www.apache.org/licenses/ **
**                      \/          \/     \/                                   **
\*                                                                              */

package code.ponfee.commons.tree;

import java.io.Serializable;
import java.util.List;

/**
 * The trait for Tree node
 * 
 * @author Ponfee
 * @param <T> the node id type
 * @param <A> the attachment biz object type
 * @param <E> the TreeTrait type
 */
public interface TreeTrait<T extends Serializable & Comparable<? super T>, A extends Serializable, E extends TreeTrait<T, A, E>>
    extends Serializable {

    void setChildren(List<E> children);

    List<E> getChildren();
}
