/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.base;

import code.ponfee.commons.base.NoArgMethodInvoker;
import code.ponfee.commons.exception.ServerException;

@FunctionalInterface
public interface Releasable {
    public static final NoArgMethodInvoker RELEASER = new NoArgMethodInvoker("close", "destroy", "release");

    public void release();

    public static void release(Object caller) {
        if (caller == null) {
            return;
        }
        try {
            if (caller instanceof AutoCloseable) {
                ((AutoCloseable)caller).close();
            } else if (caller instanceof Releasable) {
                Releasable releasable = (Releasable)caller;
                if (!releasable.isReleased()) {
                    ((Releasable)caller).release();
                }
            } else {
                RELEASER.invoke(caller);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServerException(e);
        }
    }

    default public boolean isReleased() {
        return false;
    }
}

