/*
 * Decompiled with CFR 0.152.
 */
package code.ponfee.commons.base.tuple;

import code.ponfee.commons.base.tuple.Tuple;
import java.util.Objects;

public final class Tuple2<A, B>
extends Tuple {
    private static final long serialVersionUID = -3627925720098458172L;
    public A a;
    public B b;

    public Tuple2(A a, B b) {
        this.a = a;
        this.b = b;
    }

    public static <A, B> Tuple2<A, B> of(A a, B b) {
        return new Tuple2<A, B>(a, b);
    }

    @Override
    public <T> T get(int index) {
        switch (index) {
            case 0: {
                return (T)this.a;
            }
            case 1: {
                return (T)this.b;
            }
        }
        throw new IndexOutOfBoundsException("Index: " + index);
    }

    @Override
    public <T> void set(T value, int index) {
        switch (index) {
            case 0: {
                this.a = value;
                break;
            }
            case 1: {
                this.b = value;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Index: " + index);
            }
        }
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.a, this.b};
    }

    @Override
    public String toString() {
        return "(" + this.a + ", " + this.b + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Tuple2)) {
            return false;
        }
        Tuple2 o = (Tuple2)obj;
        return this.eq(o.a, o.b);
    }

    public boolean eq(Object a, Object b) {
        return Objects.equals(this.a, a) && Objects.equals(this.b, b);
    }

    @Override
    public int hashCode() {
        int result = this.a != null ? this.a.hashCode() : 0;
        result = 31 * result + (this.b != null ? this.b.hashCode() : 0);
        return result;
    }

    @Override
    public int length() {
        return 2;
    }

    public Tuple2<A, B> copy() {
        return new Tuple2<A, B>(this.a, this.b);
    }

    public Tuple2<B, A> swap() {
        return new Tuple2<B, A>(this.b, this.a);
    }
}

